/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import jakarta.servlet.ServletInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriResolver;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.arg.SimpleRestOperationArg;
import org.apache.juneau.rest.httppart.RequestAttributes;
import org.apache.juneau.rest.httppart.RequestContent;
import org.apache.juneau.rest.httppart.RequestFormParams;
import org.apache.juneau.rest.httppart.RequestHeaders;
import org.apache.juneau.rest.httppart.RequestPathParams;
import org.apache.juneau.rest.httppart.RequestQueryParams;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ThrowingFunction;

public class RestRequestArgs
extends SimpleRestOperationArg {
    public static RestRequestArgs create(ParamInfo paramInfo) {
        if (paramInfo.isType(HttpPartParserSession.class)) {
            return new RestRequestArgs(RestRequest::getPartParserSession);
        }
        if (paramInfo.isType(HttpPartSerializerSession.class)) {
            return new RestRequestArgs(RestRequest::getPartSerializerSession);
        }
        if (paramInfo.isType(InputStream.class)) {
            return new RestRequestArgs(RestRequest::getInputStream);
        }
        if (paramInfo.isType(Locale.class)) {
            return new RestRequestArgs(RestRequest::getLocale);
        }
        if (paramInfo.isType(Messages.class)) {
            return new RestRequestArgs(RestRequest::getMessages);
        }
        if (paramInfo.isType(Reader.class)) {
            return new RestRequestArgs(RestRequest::getReader);
        }
        if (paramInfo.isType(RequestAttributes.class)) {
            return new RestRequestArgs(RestRequest::getAttributes);
        }
        if (paramInfo.isType(RequestContent.class)) {
            return new RestRequestArgs(RestRequest::getContent);
        }
        if (paramInfo.isType(RequestFormParams.class)) {
            return new RestRequestArgs(RestRequest::getFormParams);
        }
        if (paramInfo.isType(RequestHeaders.class)) {
            return new RestRequestArgs(RestRequest::getHeaders);
        }
        if (paramInfo.isType(RequestPathParams.class)) {
            return new RestRequestArgs(RestRequest::getPathParams);
        }
        if (paramInfo.isType(RequestQueryParams.class)) {
            return new RestRequestArgs(RestRequest::getQueryParams);
        }
        if (paramInfo.isType(ResourceBundle.class)) {
            return new RestRequestArgs(RestRequest::getMessages);
        }
        if (paramInfo.isType(RestRequest.class)) {
            return new RestRequestArgs(x -> x);
        }
        if (paramInfo.isType(ServletInputStream.class)) {
            return new RestRequestArgs(RestRequest::getInputStream);
        }
        if (paramInfo.isType(Swagger.class)) {
            return new RestRequestArgs(x -> x.getSwagger().orElse(null));
        }
        if (paramInfo.isType(TimeZone.class)) {
            return new RestRequestArgs(x -> x.getTimeZone().orElse(null));
        }
        if (paramInfo.isType(UriContext.class)) {
            return new RestRequestArgs(RestRequest::getUriContext);
        }
        if (paramInfo.isType(UriResolver.class)) {
            return new RestRequestArgs(RestRequest::getUriResolver);
        }
        if (paramInfo.isType(VarResolverSession.class)) {
            return new RestRequestArgs(RestRequest::getVarResolverSession);
        }
        return null;
    }

    protected <T> RestRequestArgs(ThrowingFunction<RestRequest, T> function) {
        super((RestOpSession session) -> function.apply(session.getRequest()));
    }
}

