/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;

public class SortArgs {
    private final Map<String, Boolean> sort;

    public static SortArgs create(String args) {
        if (args == null) {
            return null;
        }
        return new SortArgs(args);
    }

    public static SortArgs create(List<String> args) {
        if (args == null) {
            return null;
        }
        return new SortArgs(args);
    }

    public SortArgs(String sortArgs) {
        this(CollectionUtils.alist(StringUtils.split(sortArgs)));
    }

    public SortArgs(Collection<String> sortArgs) {
        LinkedHashMap sort = CollectionUtils.map();
        sortArgs.forEach(s -> {
            boolean isDesc = false;
            if (StringUtils.endsWith(s, '-', '+')) {
                isDesc = StringUtils.endsWith(s, '-');
                s = s.substring(0, s.length() - 1);
            }
            sort.put(s, isDesc);
        });
        this.sort = CollectionUtils.unmodifiable(sort);
    }

    public Map<String, Boolean> getSort() {
        return this.sort;
    }
}

