/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.annotation.TargetedAnnotationCBuilder;
import org.apache.juneau.annotation.TargetedAnnotationImpl;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class BeancAnnotation {
    public static final Beanc DEFAULT = BeancAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String ... on) {
        return BeancAnnotation.create().on(on);
    }

    public static Beanc copy(Beanc a, VarResolverSession r) {
        return BeancAnnotation.create().on(r.resolve(a.on())).properties(r.resolve(a.properties())).build();
    }

    public static class Builder
    extends TargetedAnnotationCBuilder {
        String properties = "";

        protected Builder() {
            super(Beanc.class);
        }

        public Beanc build() {
            return new Impl(this);
        }

        public Builder properties(String value) {
            this.properties = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Constructor<?> ... value) {
            super.on(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Beanc[] value();
    }

    public static class Applier
    extends AnnotationApplier<Beanc, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Beanc.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Beanc> ai, BeanContext.Builder b) {
            Beanc a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on())) {
                return;
            }
            b.annotations(BeancAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationImpl
    implements Beanc {
        private String properties = "";

        Impl(Builder b) {
            super(b);
            this.properties = b.properties;
            this.postConstruct();
        }

        @Override
        public String properties() {
            return this.properties;
        }
    }
}

