/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ThrowableUtils;

public final class SimpleMap<K, V>
extends AbstractMap<K, V> {
    final K[] keys;
    final V[] values;
    final SimpleMapEntry[] entries;

    public SimpleMap(K[] keys, V[] values) {
        Assertions.assertArgNotNull("keys", keys);
        Assertions.assertArgNotNull("values", values);
        Assertions.assertArg(keys.length == values.length, "keys ''{0}'' and values ''{1}'' array lengths differ", keys.length, values.length);
        this.keys = keys;
        this.values = values;
        this.entries = (SimpleMapEntry[])Array.newInstance(SimpleMapEntry.class, keys.length);
        for (int i = 0; i < keys.length; ++i) {
            Assertions.assertArg(keys[i] != null, "Keys array cannot contain a null value.", new Object[0]);
            this.entries[i] = new SimpleMapEntry(i);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ArrayUtils.asSet(this.entries);
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return ArrayUtils.asSet(this.keys);
    }

    @Override
    public V put(K key, V value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            V v = this.values[i];
            this.values[i] = value;
            return v;
        }
        throw ThrowableUtils.illegalArgumentException("No key ''{0}'' defined in map", key);
    }

    final class SimpleMapEntry
    implements Map.Entry<K, V> {
        private int index;

        SimpleMapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return SimpleMap.this.keys[this.index];
        }

        @Override
        public V getValue() {
            return SimpleMap.this.values[this.index];
        }

        @Override
        public V setValue(V val) {
            Object v = SimpleMap.this.values[this.index];
            SimpleMap.this.values[this.index] = val;
            return v;
        }
    }
}

