/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.juneau.ConfigException;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.client2.RestCallException;
import org.apache.juneau.rest.client2.RestClient;
import org.apache.juneau.rest.client2.RestRequest;
import org.apache.juneau.rest.client2.RestRequestCreated;
import org.apache.juneau.rest.mock2.MockHttpClientConnectionManager;
import org.apache.juneau.rest.mock2.MockPathResolver;
import org.apache.juneau.rest.mock2.MockRestClientBuilder;
import org.apache.juneau.rest.mock2.MockRestRequest;
import org.apache.juneau.rest.mock2.MockRestResponse;
import org.apache.juneau.rest.mock2.MockServletRequest;
import org.apache.juneau.rest.mock2.MockServletResponse;
import org.apache.juneau.rest.util.RestUtils;

public class MockRestClient
extends RestClient
implements HttpClientConnection {
    private static final String PREFIX = "RestClient.";
    public static final String MOCKRESTCLIENT_restBean = "RestClient.restBean.o";
    public static final String MOCKRESTCLIENT_restBeanCtx = "RestClient.restBeanCtx.o";
    public static final String MOCKRESTCLIENT_servletPath = "RestClient.servletPath.s";
    public static final String MOCKRESTCLIENT_contextPath = "RestClient.contextPath.s";
    public static final String MOCKRESTCLIENT_mockHttpClientConnectionManager = "RestClient.mockHttpClientConnectionManager.o";
    public static final String MOCKRESTCLIENT_pathVars = "RestClient.pathVars.oms";
    private static Map<Class<?>, RestContext> CONTEXTS_DEBUG = new ConcurrentHashMap();
    private static Map<Class<?>, RestContext> CONTEXTS_NORMAL = new ConcurrentHashMap();
    private final RestContext restBeanCtx;
    private final String contextPath;
    private final String servletPath;
    private final Map<String, String> pathVars;
    private final ThreadLocal<HttpRequest> rreq = new ThreadLocal();
    private final ThreadLocal<MockRestResponse> rres = new ThreadLocal();
    private final ThreadLocal<MockServletRequest> sreq = new ThreadLocal();
    private final ThreadLocal<MockServletResponse> sres = new ThreadLocal();

    public MockRestClient(PropertyStore ps) {
        super(MockRestClient.preInit(ps));
        this.restBeanCtx = this.getInstanceProperty(MOCKRESTCLIENT_restBeanCtx, RestContext.class, null);
        this.contextPath = this.getStringProperty(MOCKRESTCLIENT_contextPath, "");
        this.servletPath = this.getStringProperty(MOCKRESTCLIENT_servletPath, "");
        this.pathVars = this.getMapProperty(MOCKRESTCLIENT_pathVars, String.class);
        this.getInstanceProperty(MOCKRESTCLIENT_mockHttpClientConnectionManager, MockHttpClientConnectionManager.class, null).init(this);
    }

    private static PropertyStore preInit(PropertyStore ps) {
        try {
            Map<Class<?>, RestContext> contexts;
            PropertyStoreBuilder psb = ps.builder();
            Object restBean = ps.getInstanceProperty(MOCKRESTCLIENT_restBean, Object.class, null);
            String contextPath = ps.getProperty(MOCKRESTCLIENT_contextPath, String.class, null);
            String servletPath = ps.getProperty(MOCKRESTCLIENT_servletPath, String.class, null);
            String rootUrl = ps.getProperty("RestClient.rootUri.s", String.class, "http://localhost");
            boolean isDebug = ps.getProperty("Context.debug.b", Boolean.class, false);
            Class<?> c = restBean instanceof Class ? (Class<?>)restBean : restBean.getClass();
            Map<Class<?>, RestContext> map = contexts = isDebug ? CONTEXTS_DEBUG : CONTEXTS_NORMAL;
            if (!contexts.containsKey(c)) {
                boolean isClass = restBean instanceof Class;
                Object o = isClass ? ((Class)restBean).newInstance() : restBean;
                RestContextBuilder rcb = RestContext.create(o);
                if (isDebug) {
                    rcb.debug(Enablement.TRUE);
                    rcb.callLoggerConfig(RestCallLoggerConfig.DEFAULT_DEBUG);
                }
                RestContext rc = rcb.build();
                if (o instanceof RestServlet) {
                    RestServlet rs = (RestServlet)o;
                    if (!rs.isInitialized()) {
                        rs.setContext(rc);
                    }
                    rc = rs.getContext();
                } else {
                    rc.postInit();
                }
                rc.postInitChildFirst();
                contexts.put(c, rc);
            }
            RestContext restBeanCtx = contexts.get(c);
            psb.set(MOCKRESTCLIENT_restBeanCtx, restBeanCtx);
            if (servletPath == null) {
                servletPath = RestUtils.toValidContextPath(restBeanCtx.getPath());
            }
            rootUrl = rootUrl + StringUtils.emptyIfNull(contextPath) + StringUtils.emptyIfNull(servletPath);
            psb.set(MOCKRESTCLIENT_servletPath, servletPath);
            psb.set("RestClient.rootUri.s", rootUrl);
            return psb.build();
        }
        catch (Exception e) {
            throw new ConfigException(e, "Could not initialize MockRestClient", new Object[0]);
        }
    }

    public static MockRestClientBuilder create(Object impl) {
        return new MockRestClientBuilder().restBean(impl);
    }

    public static MockRestClientBuilder createLax(Object impl) {
        return new MockRestClientBuilder().restBean(impl).ignoreErrors();
    }

    public static MockRestClient build(Object impl) {
        return MockRestClient.create(impl).build();
    }

    public static MockRestClient buildLax(Object impl) {
        return MockRestClient.create(impl).ignoreErrors().build();
    }

    public static MockRestClient buildJson(Object impl) {
        return MockRestClient.create(impl).json().build();
    }

    public static MockRestClient buildJsonLax(Object impl) {
        return MockRestClient.create(impl).json().ignoreErrors().build();
    }

    public static MockRestClient buildSimpleJson(Object impl) {
        return MockRestClient.create(impl).simpleJson().build();
    }

    public static MockRestClient buildSimpleJsonLax(Object impl) {
        return MockRestClient.create(impl).simpleJson().ignoreErrors().build();
    }

    @Override
    public MockRestRequest get(Object url) throws RestCallException {
        return (MockRestRequest)super.get(url);
    }

    @Override
    public MockRestRequest get() throws RestCallException {
        return (MockRestRequest)super.get();
    }

    @Override
    public MockRestRequest put(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.put(url, body);
    }

    @Override
    public MockRestRequest put(Object url, String body, String contentType) throws RestCallException {
        return (MockRestRequest)super.put(url, body, contentType);
    }

    @Override
    public MockRestRequest put(Object url) throws RestCallException {
        return (MockRestRequest)super.put(url);
    }

    @Override
    public MockRestRequest post(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.post(url, body);
    }

    @Override
    public MockRestRequest post(Object url, String body, String contentType) throws RestCallException {
        return (MockRestRequest)super.post(url, body, contentType);
    }

    @Override
    public MockRestRequest post(Object url) throws RestCallException {
        return (MockRestRequest)super.post(url);
    }

    @Override
    public MockRestRequest delete(Object url) throws RestCallException {
        return (MockRestRequest)super.delete(url);
    }

    @Override
    public MockRestRequest options(Object url) throws RestCallException {
        return (MockRestRequest)super.options(url);
    }

    @Override
    public MockRestRequest head(Object url) throws RestCallException {
        return (MockRestRequest)super.head(url);
    }

    @Override
    public MockRestRequest formPost(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.formPost(url, body);
    }

    @Override
    public MockRestRequest formPost(Object url) throws RestCallException {
        return (MockRestRequest)super.formPost(url);
    }

    @Override
    public MockRestRequest formPostPairs(Object url, Object ... parameters) throws RestCallException {
        return (MockRestRequest)super.formPostPairs(url, parameters);
    }

    @Override
    public MockRestRequest patch(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.patch(url, body);
    }

    @Override
    public MockRestRequest patch(Object url, String body, String contentType) throws RestCallException {
        return (MockRestRequest)super.patch(url, body, contentType);
    }

    @Override
    public MockRestRequest patch(Object url) throws RestCallException {
        return (MockRestRequest)super.patch(url);
    }

    @Override
    public MockRestRequest callback(String callString) throws RestCallException {
        return (MockRestRequest)super.callback(callString);
    }

    @Override
    public MockRestRequest request(String method, Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.request(method, url, body);
    }

    @Override
    public MockRestRequest request(String method, Object url) throws RestCallException {
        return (MockRestRequest)super.request(method, url);
    }

    @Override
    public MockRestRequest request(String method, Object url, boolean hasBody) throws RestCallException {
        return (MockRestRequest)super.request(method, url, hasBody);
    }

    public HttpRequest getCurrentClientRequest() {
        return this.rreq.get();
    }

    public MockRestResponse getCurrentClientResponse() {
        return this.rres.get();
    }

    public MockServletRequest getCurrentServerRequest() {
        return this.sreq.get();
    }

    public MockServletResponse getCurrentServerResponse() {
        return this.sres.get();
    }

    MockRestClient currentResponse(MockRestResponse value) {
        this.rres.set(value);
        return this;
    }

    @Override
    protected MockRestRequest createRequest(URI uri, String method, boolean hasBody) throws RestCallException {
        return new MockRestRequest(this, uri, method, hasBody);
    }

    @Override
    protected MockRestResponse createResponse(RestRequest req, HttpResponse httpResponse, Parser parser) throws RestCallException {
        return new MockRestResponse(this, req, httpResponse, parser);
    }

    @Override
    public void close() throws IOException {
        this.rreq.remove();
        this.rres.remove();
        this.sreq.remove();
        this.sres.remove();
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isStale() {
        return false;
    }

    public void setSocketTimeout(int timeout) {
    }

    public int getSocketTimeout() {
        return Integer.MAX_VALUE;
    }

    public void shutdown() throws IOException {
    }

    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        return true;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        try {
            RequestLine rl = request.getRequestLine();
            String path = rl.getUri();
            String target = this.findTarget(request);
            HttpRequest req = this.findRestRequest(request);
            this.rreq.set(req);
            this.rres.remove();
            this.sreq.remove();
            this.sres.remove();
            path = target + path;
            MockPathResolver pr = new MockPathResolver(target, this.contextPath, this.servletPath, path, null);
            if (pr.getError() != null) {
                throw new RuntimeException(pr.getError());
            }
            MockServletRequest r = MockServletRequest.create(request.getRequestLine().getMethod(), pr.getURI(), new Object[0]).contextPath(pr.getContextPath()).servletPath(pr.getServletPath()).pathVars(this.pathVars).debug(this.isDebug());
            for (Header h : request.getAllHeaders()) {
                r.header(h.getName(), h.getValue());
            }
            this.sreq.set(r);
            this.sreq.get().applyOverrides(req);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    private HttpRequest findRestRequest(HttpRequest req) {
        if (req instanceof RestRequestCreated) {
            return ((RestRequestCreated)req).getRestRequest();
        }
        if (req instanceof HttpRequestWrapper) {
            return this.findRestRequest(((HttpRequestWrapper)req).getOriginal());
        }
        return req;
    }

    private String findTarget(HttpRequest req) {
        HttpHost httpHost;
        if (req instanceof HttpRequestWrapper && (httpHost = ((HttpRequestWrapper)req).getTarget()) != null) {
            return httpHost.toURI();
        }
        return "http://localhost";
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        byte[] body = new byte[]{};
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            long length = entity.getContentLength();
            if (length < 0L) {
                length = 1024L;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)Math.min(length, 1024L));
            entity.writeTo((OutputStream)baos);
            body = baos.toByteArray();
        }
        this.sreq.get().body(body);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        try {
            MockServletResponse res = MockServletResponse.create();
            this.restBeanCtx.execute(this.sreq.get(), res);
            if (res.getStatus() == 0) {
                throw new RuntimeException("Response status was 0.");
            }
            if (res.getStatus() < 200) {
                res.setStatus(1000 + res.getStatus());
            }
            this.sres.set(res);
            BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, res.getStatus(), res.getMessage()));
            for (Map.Entry<String, String[]> e : res.getHeaders().entrySet()) {
                for (String hv : e.getValue()) {
                    response.addHeader(e.getKey(), hv);
                }
            }
            return response;
        }
        catch (Exception e) {
            throw new HttpException(StringUtils.emptyIfNull(e.getMessage()), (Throwable)e);
        }
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        InputStream is = new ByteArrayInputStream(this.sres.get().getBody());
        Header contentEncoding = response.getLastHeader("Content-Encoding");
        if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(is);
        }
        response.setEntity((HttpEntity)new InputStreamEntity(is));
    }

    public void flush() throws IOException {
    }
}

