/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.annotation.Bean;

@Bean(bpi="resource,methods")
public class StatusStats
implements Comparable<StatusStats> {
    private final Class<?> resource;
    private final Map<java.lang.reflect.Method, Method> methods = new TreeMap<java.lang.reflect.Method, Method>();

    public StatusStats(Class<?> resource) {
        this.resource = resource;
    }

    public static StatusStats create(Class<?> resource) {
        return new StatusStats(resource);
    }

    public Class<?> getResource() {
        return this.resource;
    }

    public Method getMethod(java.lang.reflect.Method method) {
        Method m = this.methods.get(method);
        if (m == null) {
            m = new Method(method);
            this.methods.put(method, m);
        }
        return m;
    }

    public Set<Method> getMethods() {
        return new TreeSet<Method>(this.methods.values());
    }

    @Override
    public int compareTo(StatusStats o) {
        return this.resource.getName().compareTo(o.resource.getName());
    }

    @Bean(bpi="code,count")
    public static class Status
    implements Comparable<Status> {
        private int code;
        private int count;

        public Status(int code, int count) {
            this.code = code;
            this.count = count;
        }

        @Override
        public int compareTo(Status o) {
            return Integer.compare(this.code, o.code);
        }

        public int getCount() {
            return this.count;
        }
    }

    @Bean(bpi="method,codes")
    public static class Method
    implements Comparable<Method> {
        private java.lang.reflect.Method method;
        private Set<Status> codes = new TreeSet<Status>();

        Method(java.lang.reflect.Method method) {
            this.method = method;
        }

        public Method status(int code, int count) {
            this.codes.add(new Status(code, count));
            return this;
        }

        @Override
        public int compareTo(Method o) {
            return this.method.getName().compareTo(o.method.getName());
        }
    }
}

