/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.collections.OList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HtmlDocBuilder;
import org.apache.juneau.rest.annotation.AnnotationUtils;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.Logging;
import org.apache.juneau.rest.annotation.LoggingRule;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.svl.VarResolverSession;

public class RestMethodConfigApply
extends ConfigApply<RestMethod> {
    public RestMethodConfigApply(Class<RestMethod> c, VarResolverSession r) {
        super(c, r);
    }

    /*
     * WARNING - void declaration
     */
    public void apply(AnnotationInfo<RestMethod> ai, PropertyStoreBuilder psb) {
        void var10_37;
        String[] ra2;
        String[] h2;
        int i;
        String s1;
        int n;
        String[] h;
        RestMethod a = (RestMethod)ai.getAnnotation();
        MethodInfo mi = ai.getMethodOn();
        String sig = mi == null ? "Unknown" : mi.getSignature();
        String s = null;
        for (Property property : a.properties()) {
            psb.set(property.name(), (Object)this.string(property.value()));
            psb.putTo("RestContext.properties.sms", this.string(property.name()), (Object)this.string(property.value()));
        }
        for (String string : a.flags()) {
            psb.set(string, (Object)true);
            psb.putTo("RestContext.properties.sms", this.string(string), (Object)true);
        }
        if (a.serializers().length > 0) {
            psb.set("RestContext.serializers.lo", (Object)RestUtils.merge((Object[])ConverterUtils.toType((Object)psb.peek("RestContext.serializers.lo"), Object[].class), a.serializers()));
        }
        if (a.parsers().length > 0) {
            psb.set("RestContext.parsers.lo", (Object)RestUtils.merge((Object[])ConverterUtils.toType((Object)psb.peek("RestContext.parsers.lo"), Object[].class), a.parsers()));
        }
        if (a.encoders().length > 0) {
            psb.set("RestContext.encoders.lo", (Object)RestUtils.merge((Object[])ConverterUtils.toType((Object)psb.peek("RestContext.encoders.lo"), Object[].class), a.encoders()));
        }
        if (a.produces().length > 0) {
            psb.set("RestContext.produces.ls", (Object)this.strings(a.produces()));
        }
        if (a.consumes().length > 0) {
            psb.set("RestContext.consumes.ls", (Object)this.strings(a.consumes()));
        }
        for (String string : this.strings(a.defaultRequestHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new ConfigException("Invalid default request header specified on method ''{0}'': ''{1}''.  Must be in the format: ''Header-Name: header-value''", new Object[]{sig, string});
            }
            if (!StringUtils.isNotEmpty((String)h[1])) continue;
            psb.putTo("RestContext.reqHeaders.smo", h[0], (Object)h[1]);
        }
        Object[] objectArray = this.strings(a.reqHeaders());
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            Object object = objectArray[n];
            h = RestUtils.parseHeader((String)object);
            if (h == null) {
                throw new ConfigException("Invalid default request header specified on method ''{0}'': ''{1}''.  Must be in the format: ''Header-Name: header-value''", new Object[]{sig, object});
            }
            if (!StringUtils.isNotEmpty((String)h[1])) continue;
            psb.putTo("RestContext.reqHeaders.smo", h[0], (Object)h[1]);
        }
        if (a.defaultAccept().length() > 0 && StringUtils.isNotEmpty((String)(s = this.string(a.defaultAccept())))) {
            psb.putTo("RestContext.reqHeaders.smo", "Accept", (Object)s);
        }
        if (a.defaultContentType().length() > 0 && StringUtils.isNotEmpty((String)(s = this.string(a.defaultContentType())))) {
            psb.putTo("RestContext.reqHeaders.smo", "Content-Type", (Object)s);
        }
        psb.prependTo("RestContext.converters.lo", a.converters());
        psb.prependTo("RestContext.guards.lo", (Object)ArrayUtils.reverse((Object[])a.guards()));
        psb.prependTo("RestMethodContext.matchers.lo", a.matchers());
        if (!a.clientVersion().isEmpty()) {
            psb.set("RestMethodContext.clientVersion.s", (Object)a.clientVersion());
        }
        psb.set("BeanContext.beanFilters.lo", (Object)RestUtils.merge((Object[])ConverterUtils.toType((Object)psb.peek("BeanContext.beanFilters.lo"), Object[].class), a.beanFilters()));
        psb.set("BeanContext.pojoSwaps.lo", (Object)RestUtils.merge((Object[])ConverterUtils.toType((Object)psb.peek("BeanContext.pojoSwaps.lo"), Object[].class), a.pojoSwaps()));
        if (a.bpi().length > 0) {
            void var10_25;
            LinkedHashMap<String, String> bpiMap = new LinkedHashMap<String, String>();
            String[] stringArray = a.bpi();
            n = stringArray.length;
            boolean bl = false;
            while (var10_25 < n) {
                s1 = stringArray[var10_25];
                for (String s2 : StringUtils.split((String)s1, (char)';')) {
                    i = s2.indexOf(58);
                    if (i == -1) {
                        throw new ConfigException("Invalid format for @RestMethod(bpi) on method ''{0}''.  Must be in the format \"ClassName: comma-delimited-tokens\".  \nValue: {1}", new Object[]{sig, s1});
                    }
                    bpiMap.put(s2.substring(0, i).trim(), s2.substring(i + 1).trim());
                }
                ++var10_25;
            }
            psb.putAllTo("BeanContext.bpi.sms", bpiMap);
        }
        if (a.bpx().length > 0) {
            void var10_27;
            String[] bpxMap = new LinkedHashMap();
            String[] stringArray = a.bpx();
            n = stringArray.length;
            boolean bl = false;
            while (var10_27 < n) {
                s1 = stringArray[var10_27];
                for (String s2 : StringUtils.split((String)s1, (char)';')) {
                    i = s2.indexOf(58);
                    if (i == -1) {
                        throw new ConfigException("Invalid format for @RestMethod(bpx) on method ''{0}''.  Must be in the format \"ClassName: comma-delimited-tokens\".  \nValue: {1}", new Object[]{sig, s1});
                    }
                    bpxMap.put(s2.substring(0, i).trim(), s2.substring(i + 1).trim());
                }
                ++var10_27;
            }
            psb.putAllTo("BeanContext.bpx.sms", bpxMap);
        }
        if (!a.defaultCharset().isEmpty()) {
            psb.set("RestContext.defaultCharset.s", (Object)this.string(a.defaultCharset()));
        }
        if (!a.maxInput().isEmpty()) {
            psb.set("RestContext.maxInput.s", (Object)this.string(a.maxInput()));
        }
        if (!a.maxInput().isEmpty()) {
            psb.set("RestContext.maxInput.s", (Object)this.string(a.maxInput()));
        }
        if (!a.path().isEmpty()) {
            psb.prependTo("RestMethodContext.paths.ls", (Object)this.string(a.path()));
        }
        for (String string : a.paths()) {
            psb.prependTo("RestMethodContext.paths.ls", (Object)this.string(string));
        }
        if (!a.rolesDeclared().isEmpty()) {
            psb.addTo("RestContext.rolesDeclared.ss", (Object)this.strings(a.rolesDeclared()));
        }
        if (!a.roleGuard().isEmpty()) {
            psb.addTo("RestContext.roleGuard.ss", (Object)this.string(a.roleGuard()));
        }
        for (String string : a.defaultRequestHeaders()) {
            h2 = RestUtils.parseKeyValuePair(this.string(string));
            if (h2 == null) {
                throw new ConfigException("Invalid default request header specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", new Object[]{sig, s});
            }
            psb.putTo("RestMethodContext.reqHeaders.smo", h2[0], (Object)h2[1]);
        }
        for (String string : a.reqHeaders()) {
            h2 = RestUtils.parseKeyValuePair(this.string(string));
            if (h2 == null) {
                throw new ConfigException("Invalid default request header specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", new Object[]{sig, s});
            }
            psb.putTo("RestMethodContext.reqHeaders.smo", h2[0], (Object)h2[1]);
        }
        for (String string : a.attrs()) {
            ra2 = RestUtils.parseKeyValuePair(this.string(string));
            if (ra2 == null) {
                throw new ConfigException("Invalid default request attribute specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", new Object[]{sig, s});
            }
            psb.putTo("RestMethodContext.reqAttrs.smo", ra2[0], (Object)ra2[1]);
        }
        for (String string : a.reqAttrs()) {
            ra2 = RestUtils.parseKeyValuePair(this.string(string));
            if (ra2 == null) {
                throw new ConfigException("Invalid default request attribute specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", new Object[]{sig, s});
            }
            psb.putTo("RestMethodContext.reqAttrs.smo", ra2[0], (Object)ra2[1]);
        }
        if (!a.defaultAccept().isEmpty()) {
            psb.putTo("RestMethodContext.reqHeaders.smo", "Accept", (Object)this.string(a.defaultAccept()));
        }
        if (!a.defaultContentType().isEmpty()) {
            psb.putAllTo("RestMethodContext.reqHeaders.smo", (Object)this.string(a.defaultContentType()));
        }
        for (String string : a.defaultQuery()) {
            h2 = RestUtils.parseKeyValuePair(this.string(string));
            if (string == null) {
                throw new ConfigException("Invalid default query parameter specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", new Object[]{sig, s});
            }
            psb.putTo("RestMethodContext.defaultQuery.omo", h2[0], (Object)h2[1]);
        }
        for (String string : a.defaultFormData()) {
            h2 = RestUtils.parseKeyValuePair(this.string(string));
            if (string == null) {
                throw new ConfigException("Invalid default form data parameter specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", new Object[]{sig, s});
            }
            psb.putTo("RestMethodContext.defaultFormData.omo", h2[0], (Object)h2[1]);
        }
        if (!a.method().isEmpty()) {
            psb.set("RestMethodContext.httpMethod.s", (Object)this.string(a.method()));
        }
        if (!a.name().isEmpty()) {
            psb.set("RestMethodContext.httpMethod.s", (Object)this.string(a.name()));
        }
        if (a.priority() != 0) {
            psb.set("RestMethodContext.priority.i", (Object)a.priority());
        }
        if (!a.debug().isEmpty()) {
            psb.set("RestMethodContext.debug.s", (Object)this.string(a.debug()));
        }
        if (!AnnotationUtils.empty(a.logging())) {
            Logging al = a.logging();
            OMap m = new OMap((Map)psb.peek(OMap.class, "RestMethodContext.callLoggerConfig.o"));
            if (!al.useStackTraceHashing().isEmpty()) {
                m.append("useStackTraceHashing", (Object)this.bool(al.useStackTraceHashing()));
            }
            if (!al.stackTraceHashingTimeout().isEmpty()) {
                m.append("stackTraceHashingTimeout", (Object)this.integer(al.stackTraceHashingTimeout(), "@Logging(stackTraceHashingTimeout)"));
            }
            if (!al.disabled().isEmpty()) {
                m.append("disabled", (Object)this.enablement(al.disabled()));
            }
            if (!al.level().isEmpty()) {
                m.append("level", (Object)this.level(al.level(), "@Logging(level)"));
            }
            if (al.rules().length > 0) {
                OList ol = new OList();
                for (LoggingRule a2 : al.rules()) {
                    OMap m2 = new OMap();
                    if (!a2.codes().isEmpty()) {
                        m2.append("codes", (Object)this.string(a2.codes()));
                    }
                    if (!a2.exceptions().isEmpty()) {
                        m2.append("exceptions", (Object)this.string(a2.exceptions()));
                    }
                    if (!a2.debugOnly().isEmpty()) {
                        m2.append("debugOnly", (Object)this.bool(a2.debugOnly()));
                    }
                    if (!a2.level().isEmpty()) {
                        m2.append("level", (Object)this.level(a2.level(), "@LoggingRule(level)"));
                    }
                    if (!a2.req().isEmpty()) {
                        m2.append("req", (Object)this.string(a2.req()));
                    }
                    if (!a2.res().isEmpty()) {
                        m2.append("res", (Object)this.string(a2.res()));
                    }
                    if (!a2.verbose().isEmpty()) {
                        m2.append("verbose", (Object)this.bool(a2.verbose()));
                    }
                    if (!a2.disabled().isEmpty()) {
                        m2.append("disabled", (Object)this.bool(a2.disabled()));
                    }
                    ol.add((Object)m2);
                }
                m.put((Object)"rules", (Object)ol.appendAll((ObjectList)m.getList("rules")));
            }
            psb.set("RestMethodContext.callLoggerConfig.o", (Object)m);
        }
        HtmlDoc hd = a.htmldoc();
        new HtmlDocBuilder(psb).process(hd);
        Class<? extends Widget>[] classArray = hd.widgets();
        int n3 = classArray.length;
        boolean bl = false;
        while (var10_37 < n3) {
            Class<? extends Widget> wc = classArray[var10_37];
            Widget w = (Widget)ClassUtils.castOrCreate(Widget.class, wc);
            psb.prependTo("RestContext.widgets.lo", (Object)w);
            psb.prependTo("HtmlDocSerializer.script.ls", (Object)("$W{" + w.getName() + ".script}"));
            psb.prependTo("HtmlDocSerializer.script.ls", (Object)("$W{" + w.getName() + ".style}"));
            ++var10_37;
        }
    }

    private Enablement enablement(String in) {
        return Enablement.fromString(this.string(in));
    }

    private Level level(String in, String loc) {
        try {
            return Level.parse(this.string(in));
        }
        catch (Exception e) {
            throw new ConfigException("Invalid syntax for level on annotation @RestMethod({1}): {2}", new Object[]{loc, in});
        }
    }
}

