/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.parser.ParserMatch;

@ConfigurableContext(nocache=true)
public final class ParserGroup
extends BeanContext {
    public static final ParserGroup EMPTY = ParserGroup.create().build();
    private final ConcurrentHashMap<String, ParserMatch> cache = new ConcurrentHashMap();
    private final List<MediaType> mediaTypes;
    private final List<Parser> mediaTypeParsers;
    private final List<Parser> parsers;

    public static ParserGroupBuilder create() {
        return new ParserGroupBuilder();
    }

    @Override
    public ParserGroupBuilder builder() {
        return new ParserGroupBuilder(this);
    }

    public ParserGroup(PropertyStore ps, Parser[] parsers) {
        super(ps);
        this.parsers = AList.unmodifiable(parsers);
        AList lmt = AList.of();
        AList l = AList.of();
        for (Parser p : parsers) {
            for (MediaType m : p.getMediaTypes()) {
                lmt.add(m);
                l.add(p);
            }
        }
        this.mediaTypes = lmt.unmodifiable();
        this.mediaTypeParsers = l.unmodifiable();
    }

    public ParserMatch getParserMatch(String contentTypeHeader) {
        ParserMatch pm = this.cache.get(contentTypeHeader);
        if (pm != null) {
            return pm;
        }
        ContentType ct = ContentType.of(contentTypeHeader);
        int match = ct.match(this.mediaTypes);
        if (match >= 0) {
            pm = new ParserMatch(this.mediaTypes.get(match), this.mediaTypeParsers.get(match));
            this.cache.putIfAbsent(contentTypeHeader, pm);
        }
        return this.cache.get(contentTypeHeader);
    }

    public ParserMatch getParserMatch(MediaType mediaType) {
        return this.getParserMatch(mediaType.toString());
    }

    public Parser getParser(String contentTypeHeader) {
        ParserMatch pm = this.getParserMatch(contentTypeHeader);
        return pm == null ? null : pm.getParser();
    }

    public Parser getParser(MediaType mediaType) {
        ParserMatch pm = this.getParserMatch(mediaType);
        return pm == null ? null : pm.getParser();
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypes;
    }

    public List<Parser> getParsers() {
        return this.parsers;
    }

    public boolean isEmpty() {
        return this.parsers.isEmpty();
    }
}

