/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.internal.StringUtils;

public class BasicMediaTypeHeader
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private MediaType parsed;

    public static BasicMediaTypeHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicMediaTypeHeader(name, value);
    }

    public static BasicMediaTypeHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicMediaTypeHeader(name, value);
    }

    public BasicMediaTypeHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.parse();
        }
    }

    public MediaType asMediaType() {
        return this.parse();
    }

    public int match(List<MediaType> mediaTypes) {
        int matchQuant = 0;
        int matchIndex = -1;
        for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType mt = mediaTypes.get(i);
            int matchQuant2 = mt.match(this.asMediaType(), true);
            if (matchQuant2 <= matchQuant) continue;
            matchQuant = matchQuant2;
            matchIndex = i;
        }
        return matchIndex;
    }

    public final String getType() {
        return this.asMediaType().getType();
    }

    public final String getSubType() {
        return this.asMediaType().getSubType();
    }

    public final boolean hasSubType(String st) {
        return this.asMediaType().hasSubType(st);
    }

    public final List<String> getSubTypes() {
        return this.asMediaType().getSubTypes();
    }

    public final boolean isMetaSubtype() {
        return this.asMediaType().isMetaSubtype();
    }

    public final int match(MediaType o, boolean allowExtraSubTypes) {
        return this.asMediaType().match(o, allowExtraSubTypes);
    }

    public List<NameValuePair> getParameters() {
        return this.asMediaType().getParameters();
    }

    public String getParameter(String name) {
        return this.asMediaType().getParameter(name);
    }

    @Override
    public String getValue() {
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        return StringUtils.stringify(this.asMediaType());
    }

    private MediaType parse() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            o = "";
        }
        if (o instanceof MediaType) {
            return (MediaType)o;
        }
        return new MediaType(o.toString());
    }
}

