/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;

public final class ASortedMap<K, V>
extends TreeMap<K, V> {
    private static final long serialVersionUID = 1L;

    public ASortedMap() {
    }

    public ASortedMap(Comparator<K> c) {
        super(c);
    }

    public ASortedMap(Map<K, V> copy) {
        super(copy == null ? Collections.emptyMap() : copy);
    }

    public static <K, V> ASortedMap<K, V> of() {
        return new ASortedMap<K, V>();
    }

    public static <K, V> ASortedMap<K, V> of(K key, V value) {
        return new ASortedMap<K, V>().a(key, value);
    }

    public static <K, V> ASortedMap<K, V> of(Map<K, V> copy) {
        return new ASortedMap<K, V>(copy);
    }

    public static <K, V> SortedMap<K, V> unmodifiable(Map<K, V> c) {
        if (c == null || c.isEmpty()) {
            return Collections.emptySortedMap();
        }
        return new ASortedMap<K, V>(c).unmodifiable();
    }

    public static <K, V> ASortedMap<K, V> nullable(Map<K, V> c) {
        return c == null ? null : ASortedMap.of(c);
    }

    public ASortedMap<K, V> a(K k, V v) {
        this.put(k, v);
        return this;
    }

    public ASortedMap<K, V> aa(Map<K, V> c) {
        if (c != null) {
            super.putAll(c);
        }
        return this;
    }

    public SortedMap<K, V> unmodifiable() {
        return this.isEmpty() ? Collections.emptySortedMap() : Collections.unmodifiableSortedMap(this);
    }

    public String asString(WriterSerializer ws) {
        return ws.toString(this);
    }

    public String asString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    @Override
    public String toString() {
        return this.asString(SimpleJsonSerializer.DEFAULT);
    }
}

