/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.api.core.Acl;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.parser.Heading;
import org.apache.wiki.parser.HeadingListener;
import org.apache.wiki.parser.LinkParser;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.ParseException;
import org.apache.wiki.parser.PluginContent;
import org.apache.wiki.parser.VariableContent;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.XmlUtil;
import org.apache.wiki.variables.VariableManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.IllegalDataException;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Verifier;

public class JSPWikiMarkupParser
extends MarkupParser {
    protected static final int READ = 0;
    protected static final int EDIT = 1;
    protected static final int EMPTY = 2;
    protected static final int LOCAL = 3;
    protected static final int LOCALREF = 4;
    protected static final int IMAGE = 5;
    protected static final int EXTERNAL = 6;
    protected static final int INTERWIKI = 7;
    protected static final int IMAGELINK = 8;
    protected static final int IMAGEWIKILINK = 9;
    protected static final int ATTACHMENT = 10;
    private static final Logger LOG = LogManager.getLogger(JSPWikiMarkupParser.class);
    private boolean m_isbold;
    private boolean m_isitalic;
    private boolean m_istable;
    private boolean m_isPre;
    private boolean m_isEscaping;
    private boolean m_isdefinition;
    private boolean m_isPreBlock;
    private final Stack<Boolean> m_styleStack = new Stack();
    private int m_genlistlevel;
    private final StringBuilder m_genlistBulletBuffer = new StringBuilder(10);
    private final boolean m_allowPHPWikiStyleLists = true;
    private boolean m_isOpenParagraph;
    private final LinkParser m_linkParser = new LinkParser();
    private StringBuilder m_plainTextBuf = new StringBuilder(20);
    private Element m_currentElement;
    private final Map<String, Integer> m_titleSectionCounter = new HashMap<String, Integer>();
    private boolean m_camelCaseLinks;
    private boolean m_wysiwygEditorMode;
    private boolean m_plainUris;
    private boolean m_useOutlinkImage = true;
    private boolean m_useAttachmentImage = true;
    private boolean m_allowHTML;
    private boolean m_useRelNofollow;
    private final PatternCompiler m_compiler = new Perl5Compiler();
    static final String WIKIWORD_REGEX = "(^|[[:^alnum:]]+)([[:upper:]]+[[:lower:]]+[[:upper:]]+[[:alnum:]]*|(http://|https://|mailto:)([A-Za-z0-9_/\\.\\+\\?\\#\\-\\@=&;~%]+))";
    private final PatternMatcher m_camelCaseMatcher = new Perl5Matcher();
    private Pattern m_camelCasePattern;
    private int m_rowNum = 1;
    private Heading m_lastHeading;
    private static final String CAMELCASE_PATTERN = "JSPWikiMarkupParser.camelCasePattern";
    private static final String[] BLOCK_ELEMENTS = new String[]{"address", "blockquote", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "noscript", "ol", "p", "pre", "table", "ul"};
    private static final String[] EMPTY_ELEMENTS = new String[]{"area", "base", "br", "col", "hr", "img", "input", "link", "meta", "p", "param"};
    private JSPWikiMarkupParser m_cleanTranslator;
    private String m_outlinkImageURL;
    private boolean m_restartitalic;
    private boolean m_restartbold;
    private boolean m_newLine;
    protected static final int CHARACTER = 0;
    protected static final int ELEMENT = 1;
    protected static final int IGNORE = 2;

    public JSPWikiMarkupParser(Context context, Reader in) {
        super(context, in);
        this.initialize();
    }

    private void initialize() {
        this.initInlineImagePatterns();
        this.m_camelCasePattern = (Pattern)this.m_engine.getAttribute(CAMELCASE_PATTERN);
        if (this.m_camelCasePattern == null) {
            try {
                this.m_camelCasePattern = this.m_compiler.compile(WIKIWORD_REGEX, 32768);
            }
            catch (MalformedPatternException e) {
                LOG.fatal("Internal error: Someone put in a faulty pattern.", (Throwable)e);
                throw new InternalWikiException("Faulty camelcasepattern in TranslatorReader", e);
            }
            this.m_engine.setAttribute(CAMELCASE_PATTERN, (Object)this.m_camelCasePattern);
        }
        Properties props = this.m_engine.getWikiProperties();
        String cclinks = (String)this.m_context.getPage().getAttribute("jspwiki.translatorReader.camelCaseLinks");
        this.m_camelCaseLinks = cclinks != null ? TextUtil.isPositive((String)cclinks) : TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.translatorReader.camelCaseLinks", (boolean)this.m_camelCaseLinks);
        Boolean wysiwygVariable = (Boolean)this.m_context.getVariable("WYSIWYG_EDITOR_MODE");
        if (wysiwygVariable != null) {
            this.m_wysiwygEditorMode = wysiwygVariable;
        }
        this.m_plainUris = this.m_context.getBooleanWikiProperty("jspwiki.translatorReader.plainUris", this.m_plainUris);
        this.m_useOutlinkImage = this.m_context.getBooleanWikiProperty("jspwiki.translatorReader.useOutlinkImage", this.m_useOutlinkImage);
        this.m_useAttachmentImage = this.m_context.getBooleanWikiProperty("jspwiki.translatorReader.useAttachmentImage", this.m_useAttachmentImage);
        this.m_allowHTML = this.m_context.getBooleanWikiProperty("jspwiki.translatorReader.allowHTML", this.m_allowHTML);
        this.m_useRelNofollow = this.m_context.getBooleanWikiProperty("jspwiki.translatorReader.useRelNofollow", this.m_useRelNofollow);
        if (((UserManager)this.m_engine.getManager(UserManager.class)).getUserDatabase() == null || this.m_engine.getManager(AuthorizationManager.class) == null) {
            this.disableAccessRules();
        }
        this.m_context.getPage().setHasMetadata();
    }

    protected String callMutatorChain(Collection<StringTransmutator> list, String text) {
        if (list == null || list.isEmpty()) {
            return text;
        }
        for (StringTransmutator m : list) {
            text = m.mutate(this.m_context, text);
        }
        return text;
    }

    private void callHeadingListenerChain(Heading param) {
        for (HeadingListener h : this.m_headingListenerChain) {
            h.headingAdded(this.m_context, param);
        }
    }

    private Element createAnchor(int type, String link, String text, String section) {
        text = TextUtil.escapeHTMLEntities((String)text);
        section = TextUtil.escapeHTMLEntities((String)section);
        Element el = new Element("a");
        el.setAttribute("class", CLASS_TYPES[type]);
        el.setAttribute("href", link + section);
        el.addContent(text);
        return el;
    }

    private Element makeLink(int type, String link, String text, String section, Iterator<Attribute> attributes) {
        Element el = null;
        if (text == null) {
            text = link;
        }
        text = this.callMutatorChain(this.m_linkMutators, text);
        Object object = section = section != null ? "#" + (String)section : "";
        if (link.isEmpty()) {
            type = 2;
        }
        ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
        switch (type) {
            case 0: {
                el = this.createAnchor(0, this.m_context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), link), text, (String)section);
                break;
            }
            case 1: {
                el = this.createAnchor(1, this.m_context.getURL(ContextEnum.PAGE_EDIT.getRequestContext(), link), text, "");
                el.setAttribute("title", MessageFormat.format(rb.getString("markupparser.link.create"), link));
                break;
            }
            case 2: {
                el = new Element("u").addContent(text);
                break;
            }
            case 4: {
                el = this.createAnchor(4, "#ref-" + this.m_context.getName() + "-" + link, "[" + text + "]", "");
                break;
            }
            case 3: {
                el = new Element("a").setAttribute("class", "footnote");
                el.setAttribute("name", "ref-" + this.m_context.getName() + "-" + link.substring(1));
                if (!this.m_allowHTML) {
                    el.addContent("[" + TextUtil.escapeHTMLEntities((String)text) + "]");
                    break;
                }
                el.addContent("[" + text + "]");
                break;
            }
            case 5: {
                el = new Element("img").setAttribute("class", "inline");
                el.setAttribute("src", link);
                el.setAttribute("alt", text);
                break;
            }
            case 8: {
                el = new Element("img").setAttribute("class", "inline");
                el.setAttribute("src", link);
                el.setAttribute("alt", text);
                el = this.createAnchor(8, text, "", "").addContent((Content)el);
                break;
            }
            case 9: {
                String pagelink = this.m_context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), text);
                el = new Element("img").setAttribute("class", "inline");
                el.setAttribute("src", link);
                el.setAttribute("alt", text);
                el = this.createAnchor(9, pagelink, "", "").addContent((Content)el);
                break;
            }
            case 6: {
                el = this.createAnchor(6, link, text, (String)section);
                if (!this.m_useRelNofollow) break;
                el.setAttribute("rel", "nofollow");
                break;
            }
            case 7: {
                el = this.createAnchor(7, link, text, (String)section);
                break;
            }
            case 10: {
                String attlink = this.m_context.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), link);
                String infolink = this.m_context.getURL(ContextEnum.PAGE_INFO.getRequestContext(), link);
                String imglink = this.m_context.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "images/attachment_small.png");
                el = this.createAnchor(10, attlink, text, "");
                if (((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).forceDownload(attlink)) {
                    el.setAttribute("download", "");
                }
                this.pushElement(el);
                this.popElement(el.getName());
                if (this.m_useAttachmentImage) {
                    el = new Element("img").setAttribute("src", imglink);
                    el.setAttribute("border", "0");
                    el.setAttribute("alt", "(info)");
                    el = new Element("a").setAttribute("href", infolink).addContent((Content)el);
                    el.setAttribute("class", "infolink");
                    break;
                }
                el = null;
                break;
            }
        }
        if (el != null && attributes != null) {
            while (attributes.hasNext()) {
                Attribute attr = attributes.next();
                if (attr == null) continue;
                el.setAttribute(attr);
            }
        }
        if (el != null) {
            this.flushPlainText();
            this.m_currentElement.addContent((Content)el);
        }
        return el;
    }

    private static boolean isBlockLevel(String name) {
        return Arrays.binarySearch(BLOCK_ELEMENTS, name) >= 0;
    }

    private String peekAheadLine() throws IOException {
        String s = this.readUntilEOL().toString();
        if (s.length() > 10240) {
            LOG.warn("Line is longer than maximum allowed size (10240 characters.  Attempting to recover...");
            this.pushBack(s.substring(0, 10239));
        } else {
            try {
                this.pushBack(s);
            }
            catch (IOException e) {
                LOG.warn("Pushback failed: the line is probably too long.  Attempting to recover.");
            }
        }
        return s;
    }

    private int flushPlainText() {
        int numChars = this.m_plainTextBuf.length();
        if (numChars > 0) {
            Object buf = !this.m_allowHTML ? TextUtil.escapeHTMLEntities((String)this.m_plainTextBuf.toString()) : this.m_plainTextBuf.toString();
            this.m_plainTextBuf = new StringBuilder(20);
            try {
                if (this.m_camelCaseLinks && !this.m_isEscaping && ((String)buf).length() > 3) {
                    while (this.m_camelCaseMatcher.contains((String)buf, this.m_camelCasePattern)) {
                        MatchResult result = this.m_camelCaseMatcher.getMatch();
                        String firstPart = ((String)buf).substring(0, result.beginOffset(0));
                        String prefix = result.group(1);
                        if (prefix == null) {
                            prefix = "";
                        }
                        String camelCase = result.group(2);
                        String protocol = result.group(3);
                        Object uri = protocol + result.group(4);
                        buf = ((String)buf).substring(result.endOffset(0));
                        this.m_currentElement.addContent(firstPart);
                        if (prefix.endsWith("~") || prefix.indexOf(91) != -1) {
                            if (prefix.endsWith("~")) {
                                if (this.m_wysiwygEditorMode) {
                                    this.m_currentElement.addContent("~");
                                }
                                prefix = prefix.substring(0, prefix.length() - 1);
                            }
                            if (camelCase != null) {
                                this.m_currentElement.addContent(prefix + camelCase);
                                continue;
                            }
                            if (protocol == null) continue;
                            this.m_currentElement.addContent(prefix + (String)uri);
                            continue;
                        }
                        if (protocol != null) {
                            char c = ((String)uri).charAt(((String)uri).length() - 1);
                            if (c == '.' || c == ',') {
                                uri = ((String)uri).substring(0, ((String)uri).length() - 1);
                                buf = c + (String)buf;
                            }
                            this.m_currentElement.addContent(prefix);
                            this.makeDirectURILink((String)uri);
                            continue;
                        }
                        this.m_currentElement.addContent(prefix);
                        this.makeCamelCaseLink(camelCase);
                    }
                    this.m_currentElement.addContent((String)buf);
                } else {
                    this.m_currentElement.addContent((String)buf);
                }
            }
            catch (IllegalDataException e) {
                this.m_currentElement.addContent((Content)JSPWikiMarkupParser.makeError(this.cleanupSuspectData(e.getMessage())));
            }
        }
        return numChars;
    }

    private Element pushElement(Element e) {
        this.flushPlainText();
        this.m_currentElement.addContent((Content)e);
        this.m_currentElement = e;
        return e;
    }

    private Element addElement(Content e) {
        if (e != null) {
            this.flushPlainText();
            this.m_currentElement.addContent(e);
        }
        return this.m_currentElement;
    }

    private Element popElement(String s) {
        int flushedBytes = this.flushPlainText();
        Element currEl = this.m_currentElement;
        while (currEl.getParentElement() != null) {
            if (currEl.getName().equals(s) && !currEl.isRootElement()) {
                this.m_currentElement = currEl.getParentElement();
                if (flushedBytes == 0 && Arrays.binarySearch(EMPTY_ELEMENTS, s) < 0) {
                    currEl.addContent("");
                }
                return this.m_currentElement;
            }
            currEl = currEl.getParentElement();
        }
        return null;
    }

    private String readUntil(String endChars) throws IOException {
        StringBuilder sb = new StringBuilder(80);
        int ch = this.nextToken();
        while (ch != -1) {
            if (ch == 92) {
                ch = this.nextToken();
                if (ch == -1) {
                    break;
                }
            } else if (endChars.indexOf((char)ch) != -1) {
                this.pushBack(ch);
                break;
            }
            sb.append((char)ch);
            ch = this.nextToken();
        }
        return sb.toString();
    }

    private String readWhile(String endChars) throws IOException {
        StringBuilder sb = new StringBuilder(80);
        int ch = this.nextToken();
        while (ch != -1) {
            if (endChars.indexOf((char)ch) == -1) {
                this.pushBack(ch);
                break;
            }
            sb.append((char)ch);
            ch = this.nextToken();
        }
        return sb.toString();
    }

    private JSPWikiMarkupParser getCleanTranslator() {
        if (this.m_cleanTranslator == null) {
            Context dummyContext = Wiki.context().create(this.m_engine, this.m_context.getHttpRequest(), this.m_context.getPage());
            this.m_cleanTranslator = new JSPWikiMarkupParser(dummyContext, null);
            this.m_cleanTranslator.m_allowHTML = true;
        }
        return this.m_cleanTranslator;
    }

    protected String makeHeadingAnchor(String baseName, String title, Heading hd) {
        hd.m_titleText = title;
        title = MarkupParser.wikifyLink(title);
        hd.m_titleSection = this.m_engine.encodeName(title);
        if (this.m_titleSectionCounter.containsKey(hd.m_titleSection)) {
            Integer count = this.m_titleSectionCounter.get(hd.m_titleSection) + 1;
            this.m_titleSectionCounter.put(hd.m_titleSection, count);
            hd.m_titleSection = hd.m_titleSection + "-" + count;
        } else {
            this.m_titleSectionCounter.put(hd.m_titleSection, 1);
        }
        hd.m_titleAnchor = "section-" + this.m_engine.encodeName(baseName) + "-" + hd.m_titleSection;
        hd.m_titleAnchor = hd.m_titleAnchor.replace('%', '_');
        hd.m_titleAnchor = hd.m_titleAnchor.replace('/', '_');
        return hd.m_titleAnchor;
    }

    private String makeSectionTitle(String title) {
        title = title.trim();
        try {
            JSPWikiMarkupParser dtr = this.getCleanTranslator();
            dtr.setInputReader(new StringReader(title));
            WikiDocument doc = dtr.parse();
            doc.setContext(this.m_context);
            return XmlUtil.extractTextFromDocument((Document)doc);
        }
        catch (IOException e) {
            LOG.fatal("Title parsing not working", (Throwable)e);
            throw new InternalWikiException("Xml text extraction not working as expected when cleaning title" + e.getMessage(), e);
        }
    }

    public Element makeHeading(int level, String title, Heading hd) {
        Element el;
        String pageName = this.m_context.getPage().getName();
        String outTitle = this.makeSectionTitle(title);
        hd.m_level = level;
        switch (level) {
            case 1: {
                el = new Element("h4").setAttribute("id", this.makeHeadingAnchor(pageName, outTitle, hd));
                break;
            }
            case 2: {
                el = new Element("h3").setAttribute("id", this.makeHeadingAnchor(pageName, outTitle, hd));
                break;
            }
            case 3: {
                el = new Element("h2").setAttribute("id", this.makeHeadingAnchor(pageName, outTitle, hd));
                break;
            }
            default: {
                throw new InternalWikiException("Illegal heading type " + level);
            }
        }
        return el;
    }

    private Element makeCamelCaseLink(String wikiname) {
        String matchedLink = this.m_linkParsingOperations.linkIfExists(wikiname);
        this.callMutatorChain(this.m_localLinkMutatorChain, wikiname);
        if (matchedLink != null) {
            this.makeLink(0, matchedLink, wikiname, null, null);
        } else {
            this.makeLink(1, wikiname, wikiname, null, null);
        }
        return this.m_currentElement;
    }

    private Element outlinkImage() {
        Element el = null;
        if (this.m_useOutlinkImage) {
            if (this.m_outlinkImageURL == null) {
                this.m_outlinkImageURL = this.m_context.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "images/out.png");
            }
            el = new Element("img").setAttribute("class", "outlink");
            el.setAttribute("src", this.m_outlinkImageURL);
            el.setAttribute("alt", "");
        }
        return el;
    }

    private Element makeDirectURILink(String url) {
        Element result;
        String last = null;
        if (url.endsWith(",") || url.endsWith(".")) {
            last = url.substring(url.length() - 1);
            url = url.substring(0, url.length() - 1);
        }
        this.callMutatorChain(this.m_externalLinkMutatorChain, url);
        if (this.m_linkParsingOperations.isImageLink(url, this.isImageInlining(), this.getInlineImagePatterns())) {
            result = this.handleImageLink(StringUtils.replace((String)url, (String)"&amp;", (String)"&"), url, false);
        } else {
            result = this.makeLink(6, StringUtils.replace((String)url, (String)"&amp;", (String)"&"), url, null, null);
            this.addElement((Content)this.outlinkImage());
        }
        if (last != null) {
            this.m_plainTextBuf.append(last);
        }
        return result;
    }

    private Element handleImageLink(String reallink, String link, boolean hasLinkText) {
        String possiblePage = MarkupParser.cleanLink(link);
        if (this.m_linkParsingOperations.isExternalLink(link) && hasLinkText) {
            return this.makeLink(8, reallink, link, null, null);
        }
        if (this.m_linkParsingOperations.linkExists(possiblePage) && hasLinkText) {
            this.callMutatorChain(this.m_localLinkMutatorChain, possiblePage);
            return this.makeLink(9, reallink, link, null, null);
        }
        return this.makeLink(5, reallink, link, null, null);
    }

    private Element handleAccessRule(String ruleLine) {
        if (this.m_wysiwygEditorMode) {
            this.m_currentElement.addContent("[" + ruleLine + "]");
        }
        if (!this.m_parseAccessRules) {
            return this.m_currentElement;
        }
        Page page = this.m_context.getRealPage();
        if (ruleLine.startsWith("{")) {
            ruleLine = ruleLine.substring(1);
        }
        if (ruleLine.endsWith("}")) {
            ruleLine = ruleLine.substring(0, ruleLine.length() - 1);
        }
        LOG.debug("page={}, ACL = {}", (Object)page.getName(), (Object)ruleLine);
        try {
            Acl acl = ((AclManager)this.m_engine.getManager(AclManager.class)).parseAcl(page, ruleLine);
            page.setAcl(acl);
            LOG.debug(acl.toString());
        }
        catch (WikiSecurityException wse) {
            return JSPWikiMarkupParser.makeError(wse.getMessage());
        }
        return this.m_currentElement;
    }

    private Element handleMetadata(String link) {
        if (this.m_wysiwygEditorMode) {
            this.m_currentElement.addContent("[" + link + "]");
        }
        try {
            String args = link.substring(link.indexOf(32), link.length() - 1);
            String name = args.substring(0, args.indexOf(61)).trim();
            String val = args.substring(args.indexOf(61) + 1).trim();
            if (val.startsWith("'")) {
                val = val.substring(1);
            }
            if (val.endsWith("'")) {
                val = val.substring(0, val.length() - 1);
            }
            if (!name.isEmpty() && !val.isEmpty()) {
                val = ((VariableManager)this.m_engine.getManager(VariableManager.class)).expandVariables(this.m_context, val);
                this.m_context.getPage().setAttribute(name, (Object)val);
            }
        }
        catch (Exception e) {
            ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
            return JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("markupparser.error.invalidset"), link));
        }
        return this.m_currentElement;
    }

    private void disableOutputEscaping() {
        this.addElement((Content)new ProcessingInstruction("javax.xml.transform.disable-output-escaping", ""));
    }

    private Element handleHyperlinks(String linktext, int pos) {
        ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
        StringBuilder sb = new StringBuilder(linktext.length() + 80);
        if (this.m_linkParsingOperations.isAccessRule(linktext)) {
            return this.handleAccessRule(linktext);
        }
        if (this.m_linkParsingOperations.isMetadata(linktext)) {
            return this.handleMetadata(linktext);
        }
        if (this.m_linkParsingOperations.isPluginLink(linktext)) {
            block37: {
                try {
                    PluginContent pluginContent = PluginContent.parsePluginLine(this.m_context, linktext, pos);
                    if (pluginContent != null) {
                        this.addElement((Content)pluginContent);
                        pluginContent.executeParse(this.m_context);
                    }
                }
                catch (PluginException e) {
                    LOG.info(this.m_context.getRealPage().getWiki() + " : " + this.m_context.getRealPage().getName() + " - Failed to insert plugin: " + e.getMessage());
                    if (this.m_wysiwygEditorMode) break block37;
                    ResourceBundle rbPlugin = Preferences.getBundle(this.m_context, "plugin.PluginResources");
                    return this.addElement((Content)JSPWikiMarkupParser.makeError(MessageFormat.format(rbPlugin.getString("plugin.error.insertionfailed"), this.m_context.getRealPage().getWiki(), this.m_context.getRealPage().getName(), e.getMessage())));
                }
            }
            return this.m_currentElement;
        }
        try {
            LinkParser.Link link = this.m_linkParser.parse(linktext);
            linktext = link.getText();
            String linkref = link.getReference();
            if (this.m_linkParsingOperations.isVariableLink(linktext)) {
                VariableContent el = new VariableContent(linktext);
                this.addElement((Content)el);
            } else if (this.m_linkParsingOperations.isExternalLink(linkref)) {
                this.callMutatorChain(this.m_externalLinkMutatorChain, linkref);
                if (this.m_linkParsingOperations.isImageLink(linkref, this.isImageInlining(), this.getInlineImagePatterns())) {
                    this.handleImageLink(linkref, linktext, link.hasReference());
                } else {
                    this.makeLink(6, linkref, linktext, null, link.getAttributes());
                    this.addElement((Content)this.outlinkImage());
                }
            } else if (link.isInterwikiLink()) {
                String extWiki = link.getExternalWiki();
                String wikiPage = link.getExternalWikiPage();
                if (this.m_wysiwygEditorMode) {
                    this.makeLink(7, extWiki + ":" + wikiPage, linktext, null, link.getAttributes());
                } else {
                    String urlReference = this.m_engine.getInterWikiURL(extWiki);
                    if (urlReference != null) {
                        urlReference = TextUtil.replaceString((String)urlReference, (String)"%s", (String)wikiPage);
                        if (this.m_linkParsingOperations.isImageLink(urlReference = this.callMutatorChain(this.m_externalLinkMutatorChain, urlReference), this.isImageInlining(), this.getInlineImagePatterns())) {
                            this.handleImageLink(urlReference, linktext, link.hasReference());
                        } else {
                            this.makeLink(7, urlReference, linktext, null, link.getAttributes());
                        }
                        if (this.m_linkParsingOperations.isExternalLink(urlReference)) {
                            this.addElement((Content)this.outlinkImage());
                        }
                    } else {
                        Object[] args = new Object[]{TextUtil.escapeHTMLEntities((String)extWiki)};
                        this.addElement((Content)JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("markupparser.error.nointerwikiref"), args)));
                    }
                }
            } else if (linkref.startsWith("#")) {
                this.makeLink(3, linkref, linktext, null, link.getAttributes());
            } else if (TextUtil.isNumber((String)linkref)) {
                this.makeLink(4, linkref, linktext, null, link.getAttributes());
            } else {
                String attachment = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAttachmentInfoName(this.m_context, linkref);
                if (attachment != null) {
                    this.callMutatorChain(this.m_attachmentLinkMutatorChain, attachment);
                    if (this.m_linkParsingOperations.isImageLink(linkref, this.isImageInlining(), this.getInlineImagePatterns())) {
                        attachment = this.m_context.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), attachment);
                        sb.append(this.handleImageLink(attachment, linktext, link.hasReference()));
                    } else {
                        this.makeLink(10, attachment, linktext, null, link.getAttributes());
                    }
                } else {
                    int hashMark = linkref.indexOf(35);
                    if (hashMark != -1) {
                        String namedSection = linkref.substring(hashMark + 1);
                        linkref = linkref.substring(0, hashMark);
                        linkref = MarkupParser.cleanLink(linkref);
                        this.callMutatorChain(this.m_localLinkMutatorChain, linkref);
                        String matchedLink = this.m_linkParsingOperations.linkIfExists(linkref);
                        if (matchedLink != null) {
                            Object sectref = "section-" + this.m_engine.encodeName(matchedLink + "-" + JSPWikiMarkupParser.wikifyLink(namedSection));
                            sectref = ((String)sectref).replace('%', '_');
                            this.makeLink(0, matchedLink, linktext, (String)sectref, link.getAttributes());
                        } else {
                            this.makeLink(1, linkref, linktext, null, link.getAttributes());
                        }
                    } else {
                        linkref = MarkupParser.cleanLink(linkref);
                        this.callMutatorChain(this.m_localLinkMutatorChain, linkref);
                        String matchedLink = this.m_linkParsingOperations.linkIfExists(linkref);
                        if (matchedLink != null) {
                            this.makeLink(0, matchedLink, linktext, null, link.getAttributes());
                        } else {
                            this.makeLink(1, linkref, linktext, null, link.getAttributes());
                        }
                    }
                }
            }
        }
        catch (ParseException e) {
            LOG.info("Parser failure: ", (Throwable)((Object)e));
            Object[] args = new Object[]{e.getMessage()};
            this.addElement((Content)JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("markupparser.error.parserfailure"), args)));
        }
        return this.m_currentElement;
    }

    private void pushBack(String s) throws IOException {
        for (int i = s.length() - 1; i >= 0; --i) {
            this.pushBack(s.charAt(i));
        }
    }

    private Element handleBackslash() throws IOException {
        int ch = this.nextToken();
        if (ch == 92) {
            int ch2 = this.nextToken();
            if (ch2 == 92) {
                this.pushElement(new Element("br").setAttribute("clear", "all"));
                return this.popElement("br");
            }
            this.pushBack(ch2);
            this.pushElement(new Element("br"));
            return this.popElement("br");
        }
        this.pushBack(ch);
        return null;
    }

    private Element handleUnderscore() throws IOException {
        int ch = this.nextToken();
        Element el = null;
        if (ch == 95) {
            el = this.m_isbold ? this.popElement("b") : this.pushElement(new Element("b"));
            this.m_isbold = !this.m_isbold;
        } else {
            this.pushBack(ch);
        }
        return el;
    }

    private Element handleApostrophe() throws IOException {
        int ch = this.nextToken();
        Element el = null;
        if (ch == 39) {
            el = this.m_isitalic ? this.popElement("i") : this.pushElement(new Element("i"));
            this.m_isitalic = !this.m_isitalic;
        } else {
            this.pushBack(ch);
        }
        return el;
    }

    private Element handleOpenbrace(boolean isBlock) throws IOException {
        int ch = this.nextToken();
        if (ch == 123) {
            int ch2 = this.nextToken();
            if (ch2 == 123) {
                this.m_isPre = true;
                this.m_isEscaping = true;
                this.m_isPreBlock = isBlock;
                if (isBlock) {
                    this.startBlockLevel();
                    return this.pushElement(new Element("pre"));
                }
                return this.pushElement(new Element("span").setAttribute("class", "inline-code"));
            }
            this.pushBack(ch2);
            return this.pushElement(new Element("tt"));
        }
        this.pushBack(ch);
        return null;
    }

    private Element handleClosebrace() throws IOException {
        int ch2 = this.nextToken();
        if (ch2 == 125) {
            int ch3 = this.nextToken();
            if (ch3 == 125) {
                if (this.m_isPre) {
                    if (this.m_isPreBlock) {
                        this.popElement("pre");
                    } else {
                        this.popElement("span");
                    }
                    this.m_isPre = false;
                    this.m_isEscaping = false;
                    return this.m_currentElement;
                }
                this.m_plainTextBuf.append("}}}");
                return this.m_currentElement;
            }
            this.pushBack(ch3);
            if (!this.m_isEscaping) {
                return this.popElement("tt");
            }
        }
        this.pushBack(ch2);
        return null;
    }

    private Element handleDash() throws IOException {
        int ch = this.nextToken();
        if (ch == 45) {
            int ch2 = this.nextToken();
            if (ch2 == 45) {
                int ch3 = this.nextToken();
                if (ch3 == 45) {
                    while ((ch = this.nextToken()) == 45) {
                    }
                    this.pushBack(ch);
                    this.startBlockLevel();
                    this.pushElement(new Element("hr"));
                    return this.popElement("hr");
                }
                this.pushBack(ch3);
            }
            this.pushBack(ch2);
        }
        this.pushBack(ch);
        return null;
    }

    private Element handleHeading() throws IOException {
        Element el;
        int ch = this.nextToken();
        Heading hd = new Heading();
        if (ch == 33) {
            int ch2 = this.nextToken();
            if (ch2 == 33) {
                String title = this.peekAheadLine();
                el = this.makeHeading(3, title, hd);
            } else {
                this.pushBack(ch2);
                String title = this.peekAheadLine();
                el = this.makeHeading(2, title, hd);
            }
        } else {
            this.pushBack(ch);
            String title = this.peekAheadLine();
            el = this.makeHeading(1, title, hd);
        }
        this.callHeadingListenerChain(hd);
        this.m_lastHeading = hd;
        if (el != null) {
            this.pushElement(el);
        }
        return el;
    }

    private StringBuilder readUntilEOL() throws IOException {
        int ch;
        StringBuilder buf = new StringBuilder(256);
        while ((ch = this.nextToken()) != -1) {
            buf.append((char)ch);
            if (ch != 10) continue;
            break;
        }
        return buf;
    }

    private void startBlockLevel() {
        this.popElement("i");
        this.popElement("b");
        this.popElement("tt");
        if (this.m_isOpenParagraph) {
            this.m_isOpenParagraph = false;
            this.popElement("p");
            this.m_plainTextBuf.append("\n");
        }
        this.m_restartitalic = this.m_isitalic;
        this.m_restartbold = this.m_isbold;
        this.m_isitalic = false;
        this.m_isbold = false;
    }

    private static String getListType(char c) {
        if (c == '*') {
            return "ul";
        }
        if (c == '#') {
            return "ol";
        }
        throw new InternalWikiException("Parser got faulty list type: " + c);
    }

    private Element handleGeneralList() throws IOException {
        this.startBlockLevel();
        Object strBullets = this.readWhile("*#");
        int numBullets = ((String)strBullets).length();
        if (!((String)strBullets).substring(0, Math.min(numBullets, this.m_genlistlevel)).equals(this.m_genlistBulletBuffer.substring(0, Math.min(numBullets, this.m_genlistlevel)))) {
            strBullets = numBullets <= this.m_genlistlevel ? (numBullets > 1 ? this.m_genlistBulletBuffer.substring(0, numBullets - 1) : "") + ((String)strBullets).charAt(numBullets - 1) : this.m_genlistBulletBuffer + ((String)strBullets).substring(this.m_genlistlevel, numBullets);
        }
        if (((String)strBullets).substring(0, Math.min(numBullets, this.m_genlistlevel)).equals(this.m_genlistBulletBuffer.substring(0, Math.min(numBullets, this.m_genlistlevel)))) {
            if (numBullets > this.m_genlistlevel) {
                this.pushElement(new Element(JSPWikiMarkupParser.getListType(((String)strBullets).charAt(this.m_genlistlevel++))));
                while (this.m_genlistlevel < numBullets) {
                    this.pushElement(new Element("li"));
                    this.pushElement(new Element(JSPWikiMarkupParser.getListType(((String)strBullets).charAt(this.m_genlistlevel))));
                    ++this.m_genlistlevel;
                }
            } else if (numBullets < this.m_genlistlevel) {
                this.popElement("li");
                while (this.m_genlistlevel > numBullets) {
                    this.popElement(JSPWikiMarkupParser.getListType(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
                    if (this.m_genlistlevel > 0) {
                        this.popElement("li");
                    }
                    --this.m_genlistlevel;
                }
            } else if (this.m_genlistlevel > 0) {
                this.popElement("li");
            }
        } else {
            int numEqualBullets;
            int numCheckBullets = Math.min(numBullets, this.m_genlistlevel);
            for (numEqualBullets = 0; numEqualBullets < numCheckBullets && ((String)strBullets).charAt(numEqualBullets) == this.m_genlistBulletBuffer.charAt(numEqualBullets); ++numEqualBullets) {
            }
            while (this.m_genlistlevel > numEqualBullets) {
                this.popElement(JSPWikiMarkupParser.getListType(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
                if (this.m_genlistlevel > numBullets) {
                    this.popElement("li");
                }
                --this.m_genlistlevel;
            }
            this.pushElement(new Element(JSPWikiMarkupParser.getListType(((String)strBullets).charAt(numEqualBullets++))));
            for (int i = numEqualBullets; i < numBullets; ++i) {
                this.pushElement(new Element("li"));
                this.pushElement(new Element(JSPWikiMarkupParser.getListType(((String)strBullets).charAt(i))));
            }
            this.m_genlistlevel = numBullets;
        }
        this.pushElement(new Element("li"));
        this.readWhile(" ");
        this.m_genlistBulletBuffer.setLength(0);
        this.m_genlistBulletBuffer.append((String)strBullets);
        return this.m_currentElement;
    }

    private Element unwindGeneralList() {
        while (this.m_genlistlevel > 0) {
            this.popElement("li");
            this.popElement(JSPWikiMarkupParser.getListType(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
            --this.m_genlistlevel;
        }
        this.m_genlistBulletBuffer.setLength(0);
        return null;
    }

    private Element handleDefinitionList() {
        if (!this.m_isdefinition) {
            this.m_isdefinition = true;
            this.startBlockLevel();
            this.pushElement(new Element("dl"));
            return this.pushElement(new Element("dt"));
        }
        return null;
    }

    private Element handleOpenbracket() throws IOException {
        StringBuilder sb = new StringBuilder(40);
        int pos = this.getPosition();
        int ch = this.nextToken();
        boolean isPlugin = false;
        if (ch == 91) {
            if (this.m_wysiwygEditorMode) {
                sb.append('[');
            }
            sb.append((char)ch);
            while ((ch = this.nextToken()) == 91) {
                sb.append((char)ch);
            }
        }
        if (ch == 123) {
            isPlugin = true;
        }
        this.pushBack(ch);
        if (sb.length() > 0) {
            this.m_plainTextBuf.append((CharSequence)sb);
            return this.m_currentElement;
        }
        ch = this.nextToken();
        int nesting = 1;
        while (ch != -1) {
            int ch2 = this.nextToken();
            this.pushBack(ch2);
            if (isPlugin) {
                if (ch == 91 && ch2 == 123) {
                    ++nesting;
                } else {
                    if (nesting == 0 && ch == 93 && sb.charAt(sb.length() - 1) == '}') break;
                    if (ch == 125 && ch2 == 93) {
                        --nesting;
                    }
                }
            } else if (ch == 93) break;
            sb.append((char)ch);
            ch = this.nextToken();
        }
        if (ch == -1) {
            LOG.debug("Warning: unterminated link detected!");
            this.m_isEscaping = true;
            this.m_plainTextBuf.append((CharSequence)sb);
            this.flushPlainText();
            this.m_isEscaping = false;
            return this.m_currentElement;
        }
        return this.handleHyperlinks(sb.toString(), pos);
    }

    private String readBraceContent(char opening, char closing) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder(40);
        int braceLevel = 1;
        while ((ch = this.nextToken()) != -1) {
            if (ch == 92) continue;
            if (ch == opening) {
                ++braceLevel;
            } else if (ch == closing && --braceLevel == 0) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private Element handleDiv() throws IOException {
        int ch = this.nextToken();
        Element el = null;
        if (ch == 37) {
            String style = null;
            String clazz = null;
            ch = this.nextToken();
            if (ch == 40) {
                style = this.readBraceContent('(', ')');
            } else if (Character.isLetter((char)ch)) {
                this.pushBack(ch);
                clazz = this.readUntil("( \t\n\r");
                if (clazz != null) {
                    clazz = clazz.replace('.', ' ').replaceAll("[^\\s-_\\w\\x200-\\x377]+", "");
                }
                if ((ch = this.nextToken()) == 40) {
                    style = this.readBraceContent('(', ')');
                } else if (ch == 10 || ch == 13) {
                    this.pushBack(ch);
                }
            } else {
                this.pushBack(ch);
                try {
                    Boolean isSpan = this.m_styleStack.pop();
                    if (isSpan != null) {
                        el = isSpan.booleanValue() ? this.popElement("span") : this.popElement("div");
                    }
                }
                catch (EmptyStackException e) {
                    LOG.debug("Page '" + this.m_context.getName() + "' closes a %%-block that has not been opened.");
                    return this.m_currentElement;
                }
                return el;
            }
            try {
                style = StringEscapeUtils.unescapeHtml4((String)style);
                if (style != null && style.contains("javascript:")) {
                    LOG.debug("Attempt to output javascript within CSS: {}", (Object)style);
                    ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
                    return this.addElement((Content)JSPWikiMarkupParser.makeError(rb.getString("markupparser.error.javascriptattempt")));
                }
            }
            catch (NumberFormatException e) {
                ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
                String msg = MessageFormat.format(rb.getString("markupparser.error.parserfailure"), e.getMessage());
                return this.addElement((Content)JSPWikiMarkupParser.makeError(msg));
            }
            String eol = this.peekAheadLine();
            if (!eol.trim().isEmpty()) {
                el = new Element("span");
                this.m_styleStack.push(Boolean.TRUE);
            } else {
                this.startBlockLevel();
                el = new Element("div");
                this.m_styleStack.push(Boolean.FALSE);
            }
            if (style != null) {
                el.setAttribute("style", style);
            }
            if (clazz != null) {
                el.setAttribute("class", clazz);
            }
            return this.pushElement(el);
        }
        this.pushBack(ch);
        return el;
    }

    private Element handleSlash() throws IOException {
        int ch = this.nextToken();
        this.pushBack(ch);
        if (ch == 37 && !this.m_styleStack.isEmpty()) {
            return this.handleDiv();
        }
        return null;
    }

    private Element handleBar(boolean newLine) throws IOException {
        int ch;
        Element el;
        if (!this.m_istable && !newLine) {
            return null;
        }
        if (newLine) {
            if (!this.m_istable) {
                this.startBlockLevel();
                el = this.pushElement(new Element("table").setAttribute("class", "wikitable").setAttribute("border", "1"));
                this.m_istable = true;
                this.m_rowNum = 0;
            }
            ++this.m_rowNum;
            Element tr = this.m_rowNum % 2 != 0 ? new Element("tr").setAttribute("class", "odd") : new Element("tr");
            el = this.pushElement(tr);
        }
        if ((ch = this.nextToken()) == 124) {
            if (!newLine && (el = this.popElement("th")) == null) {
                this.popElement("td");
            }
            el = this.pushElement(new Element("th"));
        } else {
            if (!newLine && (el = this.popElement("td")) == null) {
                this.popElement("th");
            }
            el = this.pushElement(new Element("td"));
            this.pushBack(ch);
        }
        return el;
    }

    private Element handleTilde() throws IOException {
        int ch = this.nextToken();
        if (ch == 32) {
            if (this.m_wysiwygEditorMode) {
                this.m_plainTextBuf.append("~ ");
            }
            return this.m_currentElement;
        }
        if (ch == 124 || ch == 126 || ch == 92 || ch == 42 || ch == 35 || ch == 45 || ch == 33 || ch == 39 || ch == 95 || ch == 91 || ch == 123 || ch == 93 || ch == 125 || ch == 37) {
            if (this.m_wysiwygEditorMode) {
                this.m_plainTextBuf.append('~');
            }
            this.m_plainTextBuf.append((char)ch);
            this.m_plainTextBuf.append(this.readWhile("" + (char)ch));
            return this.m_currentElement;
        }
        this.pushBack(ch);
        return null;
    }

    private void fillBuffer(Element startElement) throws IOException {
        int ch;
        this.m_currentElement = startElement;
        this.m_newLine = true;
        boolean quitReading = false;
        this.disableOutputEscaping();
        while (!quitReading && (ch = this.nextToken()) != -1) {
            if (this.m_isEscaping) {
                if (ch == 125) {
                    if (this.handleClosebrace() != null) continue;
                    this.m_plainTextBuf.append((char)ch);
                    continue;
                }
                if (ch == -1) {
                    quitReading = true;
                    continue;
                }
                if (ch == 13) continue;
                if (ch == 60) {
                    this.m_plainTextBuf.append("&lt;");
                    continue;
                }
                if (ch == 62) {
                    this.m_plainTextBuf.append("&gt;");
                    continue;
                }
                if (ch == 38) {
                    this.m_plainTextBuf.append("&amp;");
                    continue;
                }
                if (ch == 126) {
                    String braces = this.readWhile("}");
                    if (braces.length() >= 3) {
                        this.m_plainTextBuf.append("}}}");
                        braces = braces.substring(3);
                    } else {
                        this.m_plainTextBuf.append((char)ch);
                    }
                    for (int i = braces.length() - 1; i >= 0; --i) {
                        this.pushBack(braces.charAt(i));
                    }
                    continue;
                }
                this.m_plainTextBuf.append((char)ch);
                continue;
            }
            if (this.m_newLine && ch != 42 && ch != 35 && ch != 32 && this.m_genlistlevel > 0) {
                this.m_plainTextBuf.append(this.unwindGeneralList());
            }
            if (this.m_newLine && ch != 124 && this.m_istable) {
                this.popElement("table");
                this.m_istable = false;
            }
            int skip = 2;
            try {
                skip = this.parseToken(ch);
            }
            catch (IllegalDataException e) {
                LOG.info("Page {} contains data which cannot be added to DOM tree: {}", (Object)this.m_context.getPage().getName(), (Object)e.getMessage());
                JSPWikiMarkupParser.makeError("Error: " + this.cleanupSuspectData(e.getMessage()));
            }
            switch (skip) {
                case 1: {
                    this.m_newLine = false;
                    break;
                }
                case 0: {
                    this.m_plainTextBuf.append((char)ch);
                    this.m_newLine = false;
                    break;
                }
            }
        }
        this.closeHeadings();
        this.popElement("domroot");
    }

    private String cleanupSuspectData(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Verifier.isXMLCharacter((int)c)) {
                sb.append(c);
                continue;
            }
            sb.append("0x").append(Integer.toString(c, 16).toUpperCase());
        }
        return sb.toString();
    }

    protected int parseToken(int ch) throws IOException {
        Element el = null;
        switch (ch) {
            case 13: {
                return 2;
            }
            case 10: {
                this.closeHeadings();
                this.popElement("dl");
                if (this.m_istable) {
                    this.popElement("tr");
                }
                this.m_isdefinition = false;
                if (this.m_newLine) {
                    this.startBlockLevel();
                    String nextLine = this.peekAheadLine();
                    if (nextLine.isEmpty() || !nextLine.isEmpty() && !nextLine.startsWith("{{{") && !nextLine.startsWith("----") && !nextLine.startsWith("%%") && "*#!;".indexOf(nextLine.charAt(0)) == -1) {
                        this.pushElement(new Element("p"));
                        this.m_isOpenParagraph = true;
                        if (this.m_restartitalic) {
                            this.pushElement(new Element("i"));
                            this.m_isitalic = true;
                            this.m_restartitalic = false;
                        }
                        if (this.m_restartbold) {
                            this.pushElement(new Element("b"));
                            this.m_isbold = true;
                            this.m_restartbold = false;
                        }
                    }
                } else {
                    this.m_plainTextBuf.append("\n");
                    this.m_newLine = true;
                }
                return 2;
            }
            case 92: {
                el = this.handleBackslash();
                break;
            }
            case 95: {
                el = this.handleUnderscore();
                break;
            }
            case 39: {
                el = this.handleApostrophe();
                break;
            }
            case 123: {
                el = this.handleOpenbrace(this.m_newLine);
                break;
            }
            case 125: {
                el = this.handleClosebrace();
                break;
            }
            case 45: {
                if (!this.m_newLine) break;
                el = this.handleDash();
                break;
            }
            case 33: {
                if (!this.m_newLine) break;
                el = this.handleHeading();
                break;
            }
            case 59: {
                if (!this.m_newLine) break;
                el = this.handleDefinitionList();
                break;
            }
            case 58: {
                if (!this.m_isdefinition) break;
                this.popElement("dt");
                el = this.pushElement(new Element("dd"));
                this.m_isdefinition = false;
                break;
            }
            case 91: {
                el = this.handleOpenbracket();
                break;
            }
            case 42: {
                if (!this.m_newLine) break;
                this.pushBack(42);
                el = this.handleGeneralList();
                break;
            }
            case 35: {
                if (!this.m_newLine) break;
                this.pushBack(35);
                el = this.handleGeneralList();
                break;
            }
            case 124: {
                el = this.handleBar(this.m_newLine);
                break;
            }
            case 126: {
                el = this.handleTilde();
                break;
            }
            case 37: {
                el = this.handleDiv();
                break;
            }
            case 47: {
                el = this.handleSlash();
                break;
            }
        }
        return el != null ? 1 : 0;
    }

    private void closeHeadings() {
        if (this.m_lastHeading != null && !this.m_wysiwygEditorMode) {
            this.addElement((Content)new Element("a").setAttribute("class", "hashlink").setAttribute("href", "#" + this.m_lastHeading.m_titleAnchor).setText("#"));
            this.m_lastHeading = null;
        }
        this.popElement("h2");
        this.popElement("h3");
        this.popElement("h4");
    }

    @Override
    public WikiDocument parse() throws IOException {
        WikiDocument d = new WikiDocument(this.m_context.getPage());
        d.setContext(this.m_context);
        Element rootElement = new Element("domroot");
        d.setRootElement(rootElement);
        this.fillBuffer(rootElement);
        this.paragraphify(rootElement);
        return d;
    }

    private void paragraphify(Element rootElement) {
        List kids = rootElement.getContent();
        if (rootElement.getChild("p") != null) {
            String name;
            Content c;
            ArrayList<Content> ls = new ArrayList<Content>();
            int idxOfFirstContent = 0;
            int count = 0;
            Iterator i = kids.iterator();
            while (!(!i.hasNext() || (c = (Content)i.next()) instanceof Element && JSPWikiMarkupParser.isBlockLevel(name = ((Element)c).getName()))) {
                if (!(c instanceof ProcessingInstruction)) {
                    ls.add(c);
                    if (idxOfFirstContent == 0) {
                        idxOfFirstContent = count;
                    }
                }
                ++count;
            }
            if (!ls.isEmpty()) {
                Element newel = new Element("p");
                for (Content c2 : ls) {
                    c2.detach();
                    newel.addContent(c2);
                }
                if (!newel.getTextTrim().isEmpty() || !newel.getChildren().isEmpty()) {
                    rootElement.addContent(idxOfFirstContent, (Content)newel);
                }
            }
        }
    }
}

