/*
 * Decompiled with CFR 0.152.
 */
package jodd.chalk;

public class Chalk<T extends Chalk<T>> {
    public static boolean enabled = true;
    protected static final String RESET = "0";
    protected static final String BOLD = "1";
    protected static final String UNBOLD = "22";
    protected static final String DIM = "2";
    protected static final String UNDIM = "22";
    protected static final String ITALIC = "3";
    protected static final String UNITALIC = "23";
    protected static final String UNDERLINE = "4";
    protected static final String UNUNDERLINE = "24";
    protected static final String INVERSE = "7";
    protected static final String UNINVERSE = "27";
    protected static final String HIDDEN = "8";
    protected static final String UNHIDDEN = "28";
    protected static final String STRIKETHROUGH = "9";
    protected static final String UNSTRIKETHROUGH = "29";
    protected static final String COLOR_RESET = "39";
    protected static final String BLACK = "30";
    protected static final String RED = "31";
    protected static final String GREEN = "32";
    protected static final String YELLOW = "33";
    protected static final String BLUE = "34";
    protected static final String MAGENTA = "35";
    protected static final String CYAN = "36";
    protected static final String WHITE = "37";
    protected static final String GRAY = "90";
    protected static final String BGCOLOR_RESET = "49";
    protected static final String BGBLACK = "40";
    protected static final String BGRED = "41";
    protected static final String BGGREEN = "42";
    protected static final String BGYELLOW = "43";
    protected static final String BGBLUE = "44";
    protected static final String BGMAGENTA = "45";
    protected static final String BGCYAN = "46";
    protected static final String BGWHITE = "47";
    protected StringBuilder prefix;
    protected StringBuilder suffix;
    protected String text;

    public static Chalk chalk() {
        return new Chalk();
    }

    protected T _this() {
        return (T)this;
    }

    public T bold() {
        this.startSequence(BOLD);
        this.endSequence("22");
        return this._this();
    }

    public T italic() {
        this.startSequence(ITALIC);
        this.endSequence(UNITALIC);
        return this._this();
    }

    public T dim() {
        this.startSequence(DIM);
        this.endSequence("22");
        return this._this();
    }

    public T underline() {
        this.startSequence(UNDERLINE);
        this.endSequence(UNUNDERLINE);
        return this._this();
    }

    public T inverse() {
        this.startSequence(INVERSE);
        this.endSequence(UNINVERSE);
        return this._this();
    }

    public T hidden() {
        this.startSequence(HIDDEN);
        this.endSequence(UNHIDDEN);
        return this._this();
    }

    public T strikeThrough() {
        this.startSequence(STRIKETHROUGH);
        this.endSequence(UNSTRIKETHROUGH);
        return this._this();
    }

    public T black() {
        this.startSequence(BLACK);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T red() {
        this.startSequence(RED);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T green() {
        this.startSequence(GREEN);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T yellow() {
        this.startSequence(YELLOW);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T blue() {
        this.startSequence(BLUE);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T magenta() {
        this.startSequence(MAGENTA);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T cyan() {
        this.startSequence(CYAN);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T white() {
        this.startSequence(WHITE);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T gray() {
        this.startSequence(GRAY);
        this.endSequence(COLOR_RESET);
        return this._this();
    }

    public T grey() {
        return this.gray();
    }

    public T bgBlack() {
        this.startSequence(BGBLACK);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    public T bgRed() {
        this.startSequence(BGRED);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    public T bgGreen() {
        this.startSequence(BGGREEN);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    public T bgYellow() {
        this.startSequence(BGYELLOW);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    public T bgBlue() {
        this.startSequence(BGBLUE);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    public T bgMagenta() {
        this.startSequence(BGMAGENTA);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    public T bgCyan() {
        this.startSequence(BGCYAN);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    public T bgWhite() {
        this.startSequence(BGWHITE);
        this.endSequence(BGCOLOR_RESET);
        return this._this();
    }

    protected void startSequence(String value) {
        if (this.prefix == null) {
            this.prefix = new StringBuilder();
            this.prefix.append("\u001b[");
        } else {
            this.prefix.append(";");
        }
        this.prefix.append(value);
    }

    protected void endSequence(String value) {
        if (this.suffix == null) {
            this.suffix = new StringBuilder();
            this.suffix.append("\u001b[").append(value);
        } else {
            this.suffix.insert(2, value + ";");
        }
    }

    public String on(String string) {
        if (!enabled) {
            return string;
        }
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append((CharSequence)this.prefix).append("m");
        }
        sb.append(string);
        if (this.suffix != null) {
            sb.append((CharSequence)this.suffix).append("m");
        }
        return sb.toString();
    }

    public void print(String string) {
        System.out.print(this.on(string));
    }

    public void println(String string) {
        System.out.println(this.on(string));
    }
}

