/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.List;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAntiJoin;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSemiJoin;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnfold;
import org.apache.jena.sparql.algebra.op.OpUnion;

public class TransformCopy
implements Transform {
    public static final boolean COPY_ALWAYS = true;
    public static final boolean COPY_ONLY_ON_CHANGE = false;
    private boolean alwaysCopy = false;

    public TransformCopy() {
        this(false);
    }

    public TransformCopy(boolean alwaysDuplicate) {
        this.alwaysCopy = alwaysDuplicate;
    }

    @Override
    public Op transform(OpTable opTable) {
        return this.xform(opTable);
    }

    @Override
    public Op transform(OpBGP opBGP) {
        return this.xform(opBGP);
    }

    @Override
    public Op transform(OpQuadPattern opQuadPattern) {
        return this.xform(opQuadPattern);
    }

    @Override
    public Op transform(OpQuadBlock opQuadBlock) {
        return this.xform(opQuadBlock);
    }

    @Override
    public Op transform(OpTriple opTriple) {
        return this.xform(opTriple);
    }

    @Override
    public Op transform(OpQuad opQuad) {
        return this.xform(opQuad);
    }

    @Override
    public Op transform(OpPath opPath) {
        return this.xform(opPath);
    }

    @Override
    public Op transform(OpProcedure opProc, Op subOp) {
        return this.xform(opProc, subOp);
    }

    @Override
    public Op transform(OpPropFunc opPropFunc, Op subOp) {
        return this.xform(opPropFunc, subOp);
    }

    @Override
    public Op transform(OpDatasetNames opDatasetNames) {
        return this.xform(opDatasetNames);
    }

    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        return this.xform(opFilter, subOp);
    }

    @Override
    public Op transform(OpGraph opGraph, Op subOp) {
        return this.xform(opGraph, subOp);
    }

    @Override
    public Op transform(OpService opService, Op subOp) {
        return this.xform(opService, subOp);
    }

    @Override
    public Op transform(OpAssign opAssign, Op subOp) {
        return this.xform(opAssign, subOp);
    }

    @Override
    public Op transform(OpExtend opExtend, Op subOp) {
        return this.xform(opExtend, subOp);
    }

    @Override
    public Op transform(OpUnfold opUnfold, Op subOp) {
        return this.xform(opUnfold, subOp);
    }

    @Override
    public Op transform(OpJoin opJoin, Op left, Op right) {
        return this.xform(opJoin, left, right);
    }

    @Override
    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) {
        return this.xform(opLeftJoin, left, right);
    }

    @Override
    public Op transform(OpMinus opMinus, Op left, Op right) {
        return this.xform(opMinus, left, right);
    }

    @Override
    public Op transform(OpUnion opUnion, Op left, Op right) {
        return this.xform(opUnion, left, right);
    }

    @Override
    public Op transform(OpLateral opLateral, Op left, Op right) {
        return this.xform(opLateral, left, right);
    }

    @Override
    public Op transform(OpSemiJoin opSemiJoin, Op left, Op right) {
        return this.xform(opSemiJoin, left, right);
    }

    @Override
    public Op transform(OpAntiJoin opAntiJoin, Op left, Op right) {
        return this.xform(opAntiJoin, left, right);
    }

    @Override
    public Op transform(OpConditional opCond, Op left, Op right) {
        return this.xform(opCond, left, right);
    }

    @Override
    public Op transform(OpSequence opSequence, List<Op> elts) {
        return this.xform(opSequence, elts);
    }

    @Override
    public Op transform(OpDisjunction opDisjunction, List<Op> elts) {
        return this.xform(opDisjunction, elts);
    }

    @Override
    public Op transform(OpExt opExt) {
        return this.xform(opExt);
    }

    @Override
    public Op transform(OpNull opNull) {
        return opNull.copy();
    }

    @Override
    public Op transform(OpLabel opLabel, Op subOp) {
        return this.xform(opLabel, subOp);
    }

    @Override
    public Op transform(OpList opList, Op subOp) {
        return this.xform(opList, subOp);
    }

    @Override
    public Op transform(OpOrder opOrder, Op subOp) {
        return this.xform(opOrder, subOp);
    }

    @Override
    public Op transform(OpTopN opTop, Op subOp) {
        return this.xform(opTop, subOp);
    }

    @Override
    public Op transform(OpProject opProject, Op subOp) {
        return this.xform(opProject, subOp);
    }

    @Override
    public Op transform(OpDistinct opDistinct, Op subOp) {
        return this.xform(opDistinct, subOp);
    }

    @Override
    public Op transform(OpReduced opReduced, Op subOp) {
        return this.xform(opReduced, subOp);
    }

    @Override
    public Op transform(OpSlice opSlice, Op subOp) {
        return this.xform(opSlice, subOp);
    }

    @Override
    public Op transform(OpGroup opGroup, Op subOp) {
        return this.xform(opGroup, subOp);
    }

    private Op xform(Op0 op) {
        if (!this.alwaysCopy) {
            return op;
        }
        return op.copy();
    }

    private Op xform(Op1 op, Op subOp) {
        if (!this.alwaysCopy && op.getSubOp() == subOp) {
            return op;
        }
        return op.copy(subOp);
    }

    private Op xform(Op2 op, Op left, Op right) {
        if (!this.alwaysCopy && op.getLeft() == left && op.getRight() == right) {
            return op;
        }
        return op.copy(left, right);
    }

    private Op xform(OpN op, List<Op> elts) {
        if (!this.alwaysCopy && this.equals1(elts, op.getElements())) {
            return op;
        }
        return op.copy(elts);
    }

    private Op xform(OpExt op) {
        try {
            return op.apply(this);
        }
        catch (Exception e2) {
            return op;
        }
    }

    private boolean equals1(List<Op> list1, List<Op> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }
}

