/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.MessageIdReindexingTaskDTO;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;

public class MessageIdReIndexingTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"messageId-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final MessageId messageId;

    MessageIdReIndexingTask(ReIndexerPerformer reIndexerPerformer, MessageId messageId) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.messageId = messageId;
    }

    public Task.Result run() {
        return (Task.Result)this.reIndexerPerformer.reIndexMessageId(this.messageId).block();
    }

    public TaskType type() {
        return TYPE;
    }

    MessageId getMessageId() {
        return this.messageId;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.messageId, Clock.systemUTC().instant()));
    }

    public static final class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MessageId messageId;
        private final Instant timestamp;

        AdditionalInformation(MessageId messageId, Instant timestamp) {
            this.messageId = messageId;
            this.timestamp = timestamp;
        }

        public String getMessageId() {
            return this.messageId.serialize();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MessageId.Factory messageIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MessageId.Factory messageIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.messageIdFactory = messageIdFactory;
        }

        public MessageIdReIndexingTask create(MessageIdReindexingTaskDTO dto) {
            MessageId messageId = this.messageIdFactory.fromString(dto.getMessageId());
            return new MessageIdReIndexingTask(this.reIndexerPerformer, messageId);
        }
    }
}

