/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.rmi;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.apache.james.util.RestrictingRMISocketFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class RmiRegistryFactoryBean
implements FactoryBean<Registry>,
DisposableBean {
    private final Registry registry;

    public RmiRegistryFactoryBean(int port, RestrictingRMISocketFactory restrictingRMISocketFactory) throws Exception {
        this.registry = LocateRegistry.createRegistry(port, (RMIClientSocketFactory)restrictingRMISocketFactory, (RMIServerSocketFactory)restrictingRMISocketFactory);
    }

    public Registry getObject() throws Exception {
        return this.registry;
    }

    public Class<?> getObjectType() {
        return Registry.class;
    }

    public void destroy() throws RemoteException {
        UnicastRemoteObject.unexportObject(this.registry, true);
    }
}

