/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import jakarta.inject.Inject;
import java.time.Clock;
import java.util.EnumSet;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.inmemory.InMemoryMessageManager;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class InMemoryMailboxManager
extends StoreMailboxManager {
    public static final EnumSet<MailboxManager.MailboxCapabilities> MAILBOX_CAPABILITIES = EnumSet.of(MailboxManager.MailboxCapabilities.Move, new MailboxManager.MailboxCapabilities[]{MailboxManager.MailboxCapabilities.UserFlag, MailboxManager.MailboxCapabilities.Namespace, MailboxManager.MailboxCapabilities.Annotation, MailboxManager.MailboxCapabilities.ACL, MailboxManager.MailboxCapabilities.Quota});
    public static final EnumSet<MailboxManager.MessageCapabilities> MESSAGE_CAPABILITIES = EnumSet.of(MailboxManager.MessageCapabilities.UniqueID);

    @Inject
    public InMemoryMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, SessionProvider sessionProvider, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, EventBus eventBus, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex searchIndex, PreDeletionHooks preDeletionHooks, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, Clock clock) {
        super(mailboxSessionMapperFactory, sessionProvider, locker, messageParser, messageIdFactory, (MailboxAnnotationManager)annotationManager, eventBus, storeRightManager, quotaComponents, searchIndex, MailboxManagerConfiguration.DEFAULT, preDeletionHooks, threadIdGuessingAlgorithm, clock);
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return MAILBOX_CAPABILITIES;
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return MESSAGE_CAPABILITIES;
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) {
        return new InMemoryMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailbox, this.getQuotaComponents().getQuotaManager(), this.getQuotaComponents().getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.configuration.getBatchSizes(), this.getStoreRightManager(), this.getPreDeletionHooks(), this.getThreadIdGuessingAlgorithm(), this.getClock());
    }
}

