/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.search_pipeline.DeleteSearchPipelineResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class DeleteSearchPipelineRequest
extends RequestBase
implements ToCopyableBuilder<Builder, DeleteSearchPipelineRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final String id;
    @Nullable
    private final Time timeout;
    public static final Endpoint<DeleteSearchPipelineRequest, DeleteSearchPipelineResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteSearchPipelineRequest, DeleteSearchPipelineResponse>(request -> "DELETE", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_search/pipeline/");
        SimpleEndpoint.pathEncode(request.id, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteSearchPipelineResponse._DESERIALIZER);

    private DeleteSearchPipelineRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.timeout = builder.timeout;
    }

    public static DeleteSearchPipelineRequest of(Function<Builder, ObjectBuilder<DeleteSearchPipelineRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteSearchPipelineRequest other = (DeleteSearchPipelineRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && this.id.equals(other.id) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DeleteSearchPipelineRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        private String id;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(DeleteSearchPipelineRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.id = o.id;
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.id = o.id;
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public DeleteSearchPipelineRequest build() {
            this._checkSingleUse();
            return new DeleteSearchPipelineRequest(this);
        }
    }
}

