/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import jakarta.inject.Inject;
import org.apache.james.lifecycle.api.Startable;

public class DropWizardJVMMetrics
implements Startable {
    private final MetricRegistry metricRegistry;

    @Inject
    public DropWizardJVMMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void start() {
        this.metricRegistry.register("jvm.file.descriptor", (Metric)new FileDescriptorRatioGauge());
        this.metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        this.metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register("jvm.class.loading", (Metric)new ClassLoadingGaugeSet());
    }
}

