/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends FilterOutputStream {
    private final int limit;
    private int computedBytes;

    public LimitedOutputStream(OutputStream out, int limit) {
        super(out);
        this.limit = limit;
        this.computedBytes = 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len > this.limit - this.computedBytes) {
            len = this.limit - this.computedBytes;
        }
        if (len > 0) {
            this.out.write(b, off, len);
            this.computedBytes += len;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.computedBytes < this.limit) {
            this.out.write(b);
            ++this.computedBytes;
        }
    }

    public int getComputedBytes() {
        return this.computedBytes;
    }

    public boolean isLimited() {
        return this.computedBytes >= this.limit;
    }
}

