/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.LocatedRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.GenericQualifier;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

abstract class NoPutResultSetImpl
extends BasicNoPutResultSetImpl {
    public final int resultSetNumber;
    private boolean needsRowLocation;
    private boolean needsRowLocationForDeferredCheckConstraints;
    protected ExecRow clonedExecRow;
    protected TargetResultSet targetResultSet;
    protected int[] checkNullCols;
    protected int cncLen;

    NoPutResultSetImpl(Activation activation, int n, double d, double d2) {
        super(null, activation, d, d2);
        this.resultSetNumber = n;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.activation.getResultDescription();
    }

    @Override
    public String getCursorName() {
        String string = this.activation.getCursorName();
        if (string == null && this.isForUpdate()) {
            this.activation.setCursorName(this.activation.getLanguageConnectionContext().getUniqueCursorName());
            string = this.activation.getCursorName();
        }
        return string;
    }

    @Override
    public int resultSetNumber() {
        return this.resultSetNumber;
    }

    @Override
    public void close() throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.isTopResultSet) {
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            if (languageConnectionContext.getRunTimeStatisticsMode() && !languageConnectionContext.getStatementContext().getStatementWasInvalidated()) {
                this.endExecutionTime = this.getCurrentTimeMillis();
                ExecutionFactory executionFactory = languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory();
                ResultSetStatisticsFactory resultSetStatisticsFactory = executionFactory.getResultSetStatisticsFactory();
                RunTimeStatistics runTimeStatistics = resultSetStatisticsFactory.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray);
                languageConnectionContext.setRunTimeStatisticsObject(runTimeStatistics);
                XPLAINVisitor xPLAINVisitor = executionFactory.getXPLAINFactory().getXPLAINVisitor();
                xPLAINVisitor.doXPLAIN(runTimeStatistics, this.activation);
            }
            int n = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
            for (int i = 0; i < n; ++i) {
                if (this.subqueryTrackingArray[i] == null || this.subqueryTrackingArray[i].isClosed()) continue;
                this.subqueryTrackingArray[i].close();
            }
        }
        this.isOpen = false;
    }

    @Override
    public void setTargetResultSet(TargetResultSet targetResultSet) {
        this.targetResultSet = targetResultSet;
    }

    @Override
    public void setNeedsRowLocation(boolean bl) {
        this.needsRowLocation = bl;
    }

    @Override
    public void setHasDeferrableChecks() {
        this.needsRowLocationForDeferredCheckConstraints = true;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.getNextRowCore();
        if (execRow != null) {
            this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            return execRow.getRowArray();
        }
        return null;
    }

    @Override
    public boolean needsToClone() {
        return true;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return this.needsRowLocation;
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return this.needsRowLocationForDeferredCheckConstraints;
    }

    @Override
    public void rowLocation(RowLocation rowLocation) throws StandardException {
        this.targetResultSet.changedRow(this.clonedExecRow, rowLocation);
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l) throws StandardException {
        this.targetResultSet.offendingRowLocation(rowLocation, l);
    }

    protected void clearOrderableCache(Qualifier[][] qualifierArray) throws StandardException {
        if (qualifierArray != null) {
            for (int i = 0; i < qualifierArray.length; ++i) {
                for (int j = 0; j < qualifierArray[i].length; ++j) {
                    Qualifier qualifier = qualifierArray[i][j];
                    qualifier.clearOrderableCache();
                    if (((GenericQualifier)qualifier).variantType == 0) continue;
                    qualifier.getOrderable();
                }
            }
        }
    }

    @Override
    public final void setCurrentRow(ExecRow execRow) {
        this.activation.setCurrentRow(execRow, this.resultSetNumber);
        this.currentRow = execRow;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    protected boolean skipScan(ExecIndexRow execIndexRow, ExecIndexRow execIndexRow2) throws StandardException {
        int n;
        int n2 = execIndexRow == null ? 0 : execIndexRow.nColumns();
        int n3 = execIndexRow2 == null ? 0 : execIndexRow2.nColumns();
        boolean bl = false;
        int n4 = n3;
        if (n2 > n3) {
            bl = true;
            n4 = n2;
        }
        if (n4 == 0) {
            return false;
        }
        if (this.checkNullCols == null || this.checkNullCols.length < n4) {
            this.checkNullCols = new int[n4];
        }
        this.cncLen = 0;
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            if (execIndexRow.areNullsOrdered(n)) continue;
            if (bl) {
                this.checkNullCols[this.cncLen++] = n + 1;
            }
            if (!execIndexRow.getColumn(n + 1).isNull()) continue;
            bl2 = true;
            if (!bl) break;
        }
        if (bl && bl2) {
            return true;
        }
        for (n = 0; n < n3; ++n) {
            if (execIndexRow2.areNullsOrdered(n)) continue;
            if (!bl) {
                this.checkNullCols[this.cncLen++] = n + 1;
            }
            if (bl2 || !execIndexRow2.getColumn(n + 1).isNull()) continue;
            bl2 = true;
            if (bl) break;
        }
        return bl2;
    }

    protected boolean skipRow(ExecRow execRow) throws StandardException {
        for (int i = 0; i < this.cncLen; ++i) {
            if (!execRow.getColumn(this.checkNullCols[i]).isNull()) continue;
            return true;
        }
        return false;
    }

    public static String printQualifiers(Qualifier[][] qualifierArray) {
        String string = "";
        Object object = "";
        if (qualifierArray == null) {
            return string + MessageService.getTextMessage((String)"42Z37.U", (Object[])new Object[0]);
        }
        for (int i = 0; i < qualifierArray.length; ++i) {
            for (int j = 0; j < qualifierArray[i].length; ++j) {
                Qualifier qualifier = qualifierArray[i][j];
                object = string + (String)object + MessageService.getTextMessage((String)"42Z48.U", (Object[])new Object[]{String.valueOf(i), String.valueOf(j)}) + ": " + qualifier.getColumnId() + "\n";
                int n = qualifier.getOperator();
                Object object2 = null;
                switch (n) {
                    case 2: {
                        object2 = "=";
                        break;
                    }
                    case 3: {
                        object2 = "<=";
                        break;
                    }
                    case 1: {
                        object2 = "<";
                        break;
                    }
                    default: {
                        object2 = "unknown value (" + n + ")";
                    }
                }
                object = (String)object + string + MessageService.getTextMessage((String)"42Z43.U", (Object[])new Object[0]) + ": " + (String)object2 + "\n" + string + MessageService.getTextMessage((String)"42Z44.U", (Object[])new Object[0]) + ": " + qualifier.getOrderedNulls() + "\n" + string + MessageService.getTextMessage((String)"42Z45.U", (Object[])new Object[0]) + ": " + qualifier.getUnknownRV() + "\n" + string + MessageService.getTextMessage((String)"42Z46.U", (Object[])new Object[0]) + ": " + qualifier.negateCompareResult() + "\n";
            }
        }
        return object;
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
    }

    protected DataValueDescriptor[] unpackHashValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DataValueDescriptor[]) {
            return (DataValueDescriptor[])object;
        }
        return ((LocatedRow)object).flatten();
    }
}

