/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.Wildcard;

public class MailboxQuery {
    protected final Optional<String> namespace;
    protected final Optional<Username> user;
    private final MailboxNameExpression mailboxNameExpression;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder privateMailboxesBuilder(MailboxSession session) {
        return MailboxQuery.builder().namespace("#private").username(session.getUser()).matchesAllMailboxNames();
    }

    private MailboxQuery(Optional<String> namespace, Optional<Username> user, MailboxNameExpression mailboxNameExpression) {
        this.namespace = namespace;
        this.user = user;
        this.mailboxNameExpression = mailboxNameExpression;
    }

    public Optional<String> getNamespace() {
        return this.namespace;
    }

    public Optional<Username> getUser() {
        return this.user;
    }

    public MailboxNameExpression getMailboxNameExpression() {
        return this.mailboxNameExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPrivateMailboxes(MailboxSession session) {
        Username sessionUsername = session.getUser();
        if (this.namespace.map("#private"::equals).orElse(false) == false) return false;
        if (this.user.map(arg_0 -> ((Username)sessionUsername).equals(arg_0)).orElse(false) == false) return false;
        return true;
    }

    @VisibleForTesting
    boolean belongsToRequestedNamespaceAndUser(MailboxPath mailboxPath) {
        boolean belongsToRequestedNamespace = this.namespace.map(value -> value.equals(mailboxPath.getNamespace())).orElse(true);
        boolean belongsToRequestedUser = this.user.map(value -> value.equals((Object)mailboxPath.getUser())).orElse(true);
        return belongsToRequestedNamespace && belongsToRequestedUser;
    }

    public boolean isExpressionMatch(String name) {
        return this.mailboxNameExpression.isExpressionMatch(name);
    }

    public boolean isPathMatch(MailboxPath mailboxPath) {
        return this.belongsToRequestedNamespaceAndUser(mailboxPath) && this.isExpressionMatch(mailboxPath.getName());
    }

    public boolean matches(Mailbox mailbox) {
        return this.isPathMatch(mailbox.generateAssociatedPath());
    }

    public UserBound asUserBound() {
        Preconditions.checkState((boolean)this.namespace.isPresent(), (Object)"This MailboxQuery is not user bound as namespace is missing");
        Preconditions.checkState((boolean)this.user.isPresent(), (Object)"This MailboxQuery is not user bound as user is missing");
        return new UserBound(this.namespace.get(), this.user.get(), this.mailboxNameExpression);
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxQuery) {
            MailboxQuery that = (MailboxQuery)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.user, that.user) && Objects.equals(this.mailboxNameExpression, that.mailboxNameExpression);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.namespace, this.user, this.mailboxNameExpression);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", this.namespace).add("user", this.user).add("mailboxNameExpression", (Object)this.mailboxNameExpression).toString();
    }

    public static class Builder {
        private static final Wildcard DEFAULT_WILDCARD = Wildcard.INSTANCE;
        Optional<Username> username;
        Optional<String> namespace = Optional.empty();
        Optional<MailboxNameExpression> mailboxNameExpression;

        private Builder() {
            this.username = Optional.empty();
            this.mailboxNameExpression = Optional.empty();
        }

        public Builder userAndNamespaceFrom(MailboxPath base) {
            Preconditions.checkState((!this.namespace.isPresent() ? 1 : 0) != 0);
            Preconditions.checkState((!this.username.isPresent() ? 1 : 0) != 0);
            this.namespace = Optional.ofNullable(base.getNamespace());
            this.username = Optional.ofNullable(base.getUser());
            return this;
        }

        public Builder username(Username username) {
            Preconditions.checkState((!this.username.isPresent() ? 1 : 0) != 0);
            this.username = Optional.of(username);
            return this;
        }

        public Builder user(Username username) {
            this.username(username);
            return this;
        }

        public Builder namespace(String namespace) {
            Preconditions.checkState((!this.namespace.isPresent() ? 1 : 0) != 0);
            this.namespace = Optional.of(namespace);
            return this;
        }

        public Builder privateNamespace() {
            Preconditions.checkState((!this.namespace.isPresent() ? 1 : 0) != 0);
            this.namespace = Optional.of("#private");
            return this;
        }

        public Builder expression(MailboxNameExpression expression) {
            this.mailboxNameExpression = Optional.of(expression);
            return this;
        }

        public Builder matchesAllMailboxNames() {
            this.mailboxNameExpression = Optional.of(Wildcard.INSTANCE);
            return this;
        }

        public MailboxQuery build() {
            return new MailboxQuery(this.namespace, this.username, this.mailboxNameExpression.orElse(DEFAULT_WILDCARD));
        }
    }

    public static class UserBound
    extends MailboxQuery {
        private UserBound(String namespace, Username user, MailboxNameExpression mailboxNameExpression) {
            super(Optional.of(namespace), Optional.of(user), mailboxNameExpression);
            Preconditions.checkNotNull((Object)namespace);
            Preconditions.checkNotNull((Object)user);
        }

        public String getFixedNamespace() {
            return (String)this.namespace.get();
        }

        public Username getFixedUser() {
            return (Username)this.user.get();
        }
    }
}

