/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.github.fge.lambdas.Throwing;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import io.netty.channel.Channel;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.utils.EolInputStream;
import org.apache.james.imapserver.netty.AbstractNettyImapRequestLineReader;
import org.apache.james.imapserver.netty.ImapRequestFrameDecoder;
import org.apache.james.imapserver.netty.NettyImapRequestLineReader;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class NettyStreamImapRequestLineReader
extends AbstractNettyImapRequestLineReader
implements Closeable {
    private final ImapRequestFrameDecoder.FileHolder backingFile;
    private final CountingInputStream in;
    private int literalCount = 0;
    private int read = 0;
    private final int maxFrameLength;

    public NettyStreamImapRequestLineReader(Channel channel, ImapRequestFrameDecoder.FileHolder file, boolean retry, int maxFrameLength) {
        super(channel, retry);
        this.backingFile = file;
        this.maxFrameLength = maxFrameLength;
        try {
            this.in = new CountingInputStream((InputStream)new FileInputStream(file.getFile()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            int next;
            ++this.read;
            if (this.read > this.maxFrameLength) {
                throw new DecodingException(HumanReadableText.FAILED, "Line length exceeded.");
            }
            try {
                next = this.in.read();
            }
            catch (IOException e) {
                throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Error reading from stream.", (Throwable)e);
            }
            if (next == -1) {
                throw new NettyImapRequestLineReader.NotEnoughDataException(1);
            }
            ++this.read;
            this.nextSeen = true;
            if (this.read > 8192) {
                throw new DecodingException(HumanReadableText.FAILED, "Line length exceeded.");
            }
            this.nextChar = (char)next;
        }
        return this.nextChar;
    }

    public Literal read(int size, boolean extraCRLF) throws DecodingException {
        this.nextSeen = false;
        this.nextChar = '\u0000';
        if (this.literalCount > NettyImapRequestLineReader.MAXIMUM_LITERAL_COUNT) {
            throw new DecodingException(HumanReadableText.FAILED_LITERAL_SIZE_EXCEEDED, "Too many literals. " + NettyImapRequestLineReader.MAXIMUM_LITERAL_COUNT + " allowed but got " + this.literalCount);
        }
        ++this.literalCount;
        try {
            long offset = this.in.getCount();
            this.in.skip((long)size);
            return new FileLiteral(offset, size, extraCRLF, this.backingFile, this);
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Could not copy litteral", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private static class FileLiteral
    implements Literal,
    Closeable {
        private final long offset;
        private final int size;
        private final boolean extraCRLF;
        private final ImapRequestFrameDecoder.FileHolder file;
        private final AbstractNettyImapRequestLineReader reader;

        private FileLiteral(long offset, int size, boolean extraCRLF, ImapRequestFrameDecoder.FileHolder file, AbstractNettyImapRequestLineReader reader) {
            this.offset = offset;
            this.size = size;
            this.extraCRLF = extraCRLF;
            this.file = file;
            this.reader = reader;
        }

        @Override
        public void close() {
            Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
                this.file.dispose();
                this.reader.close();
            })).subscribeOn(Schedulers.boundedElastic()).subscribe();
        }

        public long size() {
            return Math.min(this.file.getFile().length() - this.offset, (long)this.size);
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream fileInputStream = new FileInputStream(this.file.getFile());
            fileInputStream.skip(this.offset);
            InputStream limitedStream = ByteStreams.limit((InputStream)fileInputStream, (long)this.size);
            if (this.extraCRLF) {
                return new EolInputStream((ImapRequestLineReader)this.reader, limitedStream);
            }
            return limitedStream;
        }
    }
}

