/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.cassandra.BlobTables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraBucketDAO {
    private final BlobId.Factory blobIdFactory;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insert;
    private final PreparedStatement insertPart;
    private final PreparedStatement select;
    private final PreparedStatement selectPart;
    private final PreparedStatement delete;
    private final PreparedStatement deleteParts;
    private final PreparedStatement listAll;
    private final PreparedStatement listBucketContent;
    private final DriverExecutionProfile optimisticConsistencyLevelProfile;

    @Inject
    @VisibleForTesting
    public CassandraBucketDAO(BlobId.Factory blobIdFactory, CqlSession session) {
        this.blobIdFactory = blobIdFactory;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.optimisticConsistencyLevelProfile = JamesExecutionProfiles.getOptimisticConsistencyLevelProfile((CqlSession)session);
        this.insert = session.prepare(QueryBuilder.insertInto((String)"blobsInBucket").value(BlobTables.BucketBlobTable.BUCKET, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.BUCKET)).value(BlobTables.BucketBlobTable.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.ID)).value(BlobTables.BucketBlobTable.NUMBER_OF_CHUNK, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.NUMBER_OF_CHUNK)).build());
        this.insertPart = session.prepare(QueryBuilder.insertInto((String)"blobPartsInBucket").value(BlobTables.BucketBlobParts.BUCKET, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobParts.BUCKET)).value(BlobTables.BucketBlobParts.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobParts.ID)).value(BlobTables.BucketBlobParts.CHUNK_NUMBER, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobParts.CHUNK_NUMBER)).value(BlobTables.BucketBlobParts.DATA, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobParts.DATA)).build());
        this.select = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"blobsInBucket").all().whereColumn(BlobTables.BucketBlobTable.BUCKET).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.BUCKET))).whereColumn(BlobTables.BucketBlobTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.ID))).build());
        this.selectPart = session.prepare(((Select)((Select)((Select)QueryBuilder.selectFrom((String)"blobPartsInBucket").all().whereColumn(BlobTables.BucketBlobTable.BUCKET).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.BUCKET))).whereColumn(BlobTables.BucketBlobTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.ID))).whereColumn(BlobTables.BucketBlobParts.CHUNK_NUMBER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobParts.CHUNK_NUMBER))).build());
        this.listAll = session.prepare(QueryBuilder.selectFrom((String)"blobsInBucket").all().build());
        this.listBucketContent = session.prepare(((Select)QueryBuilder.selectFrom((String)"blobsInBucket").all().whereColumn(BlobTables.BucketBlobTable.BUCKET).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.BUCKET))).allowFiltering().build());
        this.deleteParts = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"blobPartsInBucket").whereColumn(BlobTables.BucketBlobParts.BUCKET).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobParts.BUCKET))).whereColumn(BlobTables.BucketBlobParts.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobParts.ID))).build());
        this.delete = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"blobsInBucket").whereColumn(BlobTables.BucketBlobTable.BUCKET).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.BUCKET))).whereColumn(BlobTables.BucketBlobTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.ID))).build());
    }

    Mono<Void> writePart(ByteBuffer data, BucketName bucketName, BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertPart.bind(new Object[0]).setString(BlobTables.BucketBlobParts.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobParts.ID, blobId.asString())).setInt(BlobTables.BucketBlobParts.CHUNK_NUMBER, position)).setByteBuffer(BlobTables.BucketBlobParts.DATA, data));
    }

    Mono<Void> saveBlobPartsReferences(BucketName bucketName, BlobId blobId, int numberOfChunk) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setString(BlobTables.BucketBlobTable.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobTable.ID, blobId.asString())).setInt(BlobTables.BucketBlobTable.NUMBER_OF_CHUNK, numberOfChunk));
    }

    Mono<Integer> selectRowCount(BucketName bucketName, BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)((BoundStatement)this.select.bind(new Object[0]).setString(BlobTables.BucketBlobTable.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobTable.ID, blobId.asString())).map(row -> row.getInt(BlobTables.BucketBlobTable.NUMBER_OF_CHUNK));
    }

    Mono<Integer> selectRowCountClOne(BucketName bucketName, BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow(((BoundStatement)((BoundStatement)this.select.bind(new Object[0]).setString(BlobTables.BucketBlobTable.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobTable.ID, blobId.asString())).setExecutionProfile(this.optimisticConsistencyLevelProfile)).map(row -> row.getInt(BlobTables.BucketBlobTable.NUMBER_OF_CHUNK));
    }

    Mono<ByteBuffer> readPart(BucketName bucketName, BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)((BoundStatement)((BoundStatement)this.selectPart.bind(new Object[0]).setString(BlobTables.BucketBlobParts.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobParts.ID, blobId.asString())).setInt(BlobTables.BucketBlobParts.CHUNK_NUMBER, position)).map(this::rowToData);
    }

    Mono<ByteBuffer> readPartClOne(BucketName bucketName, BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeSingleRow(((BoundStatement)((BoundStatement)((BoundStatement)this.selectPart.bind(new Object[0]).setString(BlobTables.BucketBlobParts.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobParts.ID, blobId.asString())).setInt(BlobTables.BucketBlobParts.CHUNK_NUMBER, position)).setExecutionProfile(this.optimisticConsistencyLevelProfile)).map(this::rowToData);
    }

    Mono<Void> deletePosition(BucketName bucketName, BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.delete.bind(new Object[0]).setString(BlobTables.BucketBlobTable.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobTable.ID, blobId.asString()));
    }

    Mono<Void> deleteParts(BucketName bucketName, BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteParts.bind(new Object[0]).setString(BlobTables.BucketBlobParts.BUCKET, bucketName.asString())).setString(BlobTables.BucketBlobParts.ID, blobId.asString()));
    }

    public Flux<Pair<BucketName, BlobId>> listAll() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listAll.bind(new Object[0])).map(row -> Pair.of((Object)BucketName.of((String)row.getString(BlobTables.BucketBlobTable.BUCKET)), (Object)this.blobIdFactory.parse(row.getString(BlobTables.BucketBlobTable.ID))));
    }

    public Flux<BlobId> listAll(BucketName bucketName) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBucketContent.bind(new Object[0]).setString(BlobTables.BucketBlobTable.BUCKET, bucketName.asString())).map(row -> this.blobIdFactory.parse(row.getString(BlobTables.BucketBlobTable.ID)));
    }

    private ByteBuffer rowToData(Row row) {
        return row.getByteBuffer(BlobTables.BucketBlobParts.DATA);
    }
}

