/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import com.google.common.base.MoreObjects;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.message.request.AbstractImapRequest;

public class ListRequest
extends AbstractImapRequest {
    private final String baseReferenceName;
    private final String mailboxPattern;
    private final EnumSet<ListSelectOption> selectOptions;
    private final EnumSet<ListReturnOption> returnOptions;
    private final Optional<StatusDataItems> statusDataItems;

    public ListRequest(String referenceName, String mailboxPattern, Tag tag) {
        this(ImapConstants.LIST_COMMAND, referenceName, mailboxPattern, tag, EnumSet.noneOf(ListSelectOption.class), EnumSet.noneOf(ListReturnOption.class), Optional.empty());
    }

    public ListRequest(ImapCommand imapCommand, String referenceName, String mailboxPattern, Tag tag, EnumSet<ListSelectOption> selectOptions, EnumSet<ListReturnOption> returnOptions, Optional<StatusDataItems> statusDataItems) {
        super(tag, imapCommand);
        this.baseReferenceName = referenceName;
        this.mailboxPattern = mailboxPattern;
        this.selectOptions = selectOptions;
        this.returnOptions = returnOptions;
        this.statusDataItems = statusDataItems;
    }

    public final String getBaseReferenceName() {
        return this.baseReferenceName;
    }

    public final String getMailboxPattern() {
        return this.mailboxPattern;
    }

    public EnumSet<ListSelectOption> getSelectOptions() {
        return this.selectOptions;
    }

    public EnumSet<ListReturnOption> getReturnOptions() {
        return this.returnOptions;
    }

    public boolean selectSubscribed() {
        return this.getSelectOptions().contains((Object)ListSelectOption.SUBSCRIBED);
    }

    public boolean selectRemote() {
        return this.getSelectOptions().contains((Object)ListSelectOption.REMOTE);
    }

    public Optional<StatusDataItems> getStatusDataItems() {
        return this.statusDataItems;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseReferenceName", (Object)this.baseReferenceName).add("mailboxPattern", (Object)this.mailboxPattern).add("selectOptions", this.selectOptions).add("returnOptions", this.returnOptions).add("statusDataItem", this.statusDataItems.orElse(null)).toString();
    }

    public static enum ListReturnOption {
        CHILDREN,
        SUBSCRIBED,
        STATUS,
        MYRIGHTS,
        SPECIAL_USE;

    }

    public static enum ListSelectOption {
        REMOTE,
        RECURSIVEMATCH,
        SUBSCRIBED,
        SPECIAL_USE;

    }
}

