/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ChangeLogEntryAttributeExceededMaxValuesCount
implements Serializable {
    @NotNull
    private static final String TOKEN_NAME_ATTR = "attr";
    @NotNull
    private static final String TOKEN_NAME_BEFORE_COUNT = StaticUtils.toLowerCase("beforeCount");
    @NotNull
    private static final String TOKEN_NAME_AFTER_COUNT = StaticUtils.toLowerCase("afterCount");
    private static final long serialVersionUID = -4689107630879614032L;
    private final long afterCount;
    private final long beforeCount;
    @NotNull
    private final String attributeName;
    @NotNull
    private final String stringRepresentation;

    public ChangeLogEntryAttributeExceededMaxValuesCount(@NotNull String s) throws LDAPException {
        this.stringRepresentation = s;
        String name = null;
        Long before = null;
        Long after = null;
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int equalPos = token.indexOf(61);
            if (equalPos < 0) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_MALFORMED_TOKEN.get(s, token));
            }
            String tokenName = StaticUtils.toLowerCase(token.substring(0, equalPos).trim());
            String value = token.substring(equalPos + 1).trim();
            if (tokenName.equals(TOKEN_NAME_ATTR)) {
                if (name == null) {
                    name = value;
                    continue;
                }
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_REPEATED_TOKEN.get(s, tokenName));
            }
            if (tokenName.equals(TOKEN_NAME_BEFORE_COUNT)) {
                if (before == null) {
                    try {
                        before = Long.parseLong(value);
                        continue;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_MALFORMED_COUNT.get(s, tokenName), e);
                    }
                }
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_REPEATED_TOKEN.get(s, tokenName));
            }
            if (!tokenName.equals(TOKEN_NAME_AFTER_COUNT)) continue;
            if (after == null) {
                try {
                    after = Long.parseLong(value);
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_REPEATED_TOKEN.get(s, tokenName), e);
                }
            }
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_REPEATED_TOKEN.get(s, tokenName));
        }
        if (name == null) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_MISSING_TOKEN.get(s, TOKEN_NAME_ATTR));
        }
        if (before == null) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_MISSING_TOKEN.get(s, TOKEN_NAME_BEFORE_COUNT));
        }
        if (after == null) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VALUE_COUNT_MISSING_TOKEN.get(s, TOKEN_NAME_AFTER_COUNT));
        }
        this.attributeName = name;
        this.beforeCount = before;
        this.afterCount = after;
    }

    @NotNull
    public String getAttributeName() {
        return this.attributeName;
    }

    public long getBeforeCount() {
        return this.beforeCount;
    }

    public long getAfterCount() {
        return this.afterCount;
    }

    public int hashCode() {
        int hashCode = StaticUtils.toLowerCase(this.attributeName).hashCode();
        hashCode = (int)((long)(hashCode * 31) + this.beforeCount);
        hashCode = (int)((long)(hashCode * 31) + this.afterCount);
        return hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeLogEntryAttributeExceededMaxValuesCount)) {
            return false;
        }
        ChangeLogEntryAttributeExceededMaxValuesCount c = (ChangeLogEntryAttributeExceededMaxValuesCount)o;
        return this.beforeCount == c.beforeCount && this.afterCount == c.afterCount && this.attributeName.equalsIgnoreCase(c.attributeName);
    }

    @NotNull
    public String toString() {
        return this.stringRepresentation;
    }
}

