/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.Callable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.james.backends.cassandra.init.ClusterFactory;
import org.apache.james.backends.cassandra.init.KeyspaceFactory;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

@Singleton
public class ResilientClusterProvider
implements Provider<CqlSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResilientClusterProvider.class);
    private final CqlSession cluster;

    @Inject
    @VisibleForTesting
    ResilientClusterProvider(ClusterConfiguration configuration, KeyspaceConfiguration keyspaceConfiguration) {
        Duration waitDelay = Duration.ofMillis(configuration.getMinDelay());
        this.cluster = (CqlSession)Mono.fromCallable(this.getClusterRetryCallable(configuration, keyspaceConfiguration)).doOnError(e -> LOGGER.warn("Error establishing Cassandra connection. Next retry scheduled in {} ms", (Object)waitDelay, e)).retryWhen((Retry)Retry.backoff((long)configuration.getMaxRetry(), (Duration)waitDelay).scheduler(Schedulers.boundedElastic())).block();
    }

    private Callable<CqlSession> getClusterRetryCallable(ClusterConfiguration configuration, KeyspaceConfiguration keyspaceConfiguration) {
        LOGGER.info("Trying to connect to Cassandra service at {} (list {})", (Object)LocalDateTime.now(), (Object)ImmutableList.copyOf(configuration.getHosts()).toString());
        return () -> {
            CqlSession cluster = ClusterFactory.create(configuration, keyspaceConfiguration);
            try {
                KeyspaceFactory.keyspaceExist(cluster, "any");
                return cluster;
            }
            catch (Exception e) {
                cluster.close();
                throw e;
            }
        };
    }

    public CqlSession get() {
        return this.cluster;
    }

    @PreDestroy
    public void stop() {
        this.cluster.closeAsync();
    }
}

