/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.github.fge.lambdas.Throwing;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.events.Group;
import org.apache.james.events.tables.CassandraEventDeadLettersGroupTable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEventDeadLettersGroupDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectAllStatement;
    private final PreparedStatement deleteStatement;

    @Inject
    CassandraEventDeadLettersGroupDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertStatement = this.prepareInsertStatement(session);
        this.selectAllStatement = this.prepareSelectStatement(session);
        this.deleteStatement = this.prepareDeleteStatement(session);
    }

    private PreparedStatement prepareInsertStatement(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"group_table").value(CassandraEventDeadLettersGroupTable.GROUP, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersGroupTable.GROUP)).build());
    }

    private PreparedStatement prepareSelectStatement(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"group_table").column(CassandraEventDeadLettersGroupTable.GROUP).build());
    }

    private PreparedStatement prepareDeleteStatement(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"group_table").whereColumn(CassandraEventDeadLettersGroupTable.GROUP).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersGroupTable.GROUP))).build());
    }

    Mono<Void> storeGroup(Group group) {
        return this.executor.executeVoid((Statement)this.insertStatement.bind(new Object[0]).setString(CassandraEventDeadLettersGroupTable.GROUP, group.asString()));
    }

    Flux<Group> retrieveAllGroups() {
        return this.executor.executeRows((Statement)this.selectAllStatement.bind(new Object[0])).map((Function)Throwing.function(row -> Group.deserialize((String)row.getString(CassandraEventDeadLettersGroupTable.GROUP))));
    }

    Mono<Void> deleteGroup(Group group) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind(new Object[0]).setString(CassandraEventDeadLettersGroupTable.GROUP, group.asString()));
    }
}

