/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.FielddataResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class FielddataRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    private final List<String> fields;
    public static final Endpoint<FielddataRequest, FielddataResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FielddataRequest, FielddataResponse>(request -> "GET", request -> {
        boolean _fields = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.fields())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/fielddata");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/fielddata");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.fields.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, FielddataResponse._DESERIALIZER);

    private FielddataRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static FielddataRequest of(Function<Builder, ObjectBuilder<FielddataRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<String> fields() {
        return this.fields;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FielddataRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<String> fields;

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Override
        public FielddataRequest build() {
            this._checkSingleUse();
            return new FielddataRequest(this);
        }
    }
}

