/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogBatchStartingPoint;
import com.unboundid.util.Base64;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ResumeWithTokenStartingPoint
extends ChangelogBatchStartingPoint {
    static final byte TYPE = -128;
    private static final long serialVersionUID = -101217605840282165L;
    @NotNull
    private final ASN1OctetString resumeToken;

    public ResumeWithTokenStartingPoint(@NotNull ASN1OctetString resumeToken) {
        Validator.ensureNotNull(resumeToken);
        this.resumeToken = resumeToken;
    }

    @NotNull
    public ASN1OctetString getResumeToken() {
        return this.resumeToken;
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        return new ASN1OctetString(-128, this.resumeToken.getValue());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ResumeWithTokenStartingPoint(token='");
        Base64.encode(this.resumeToken.getValue(), buffer);
        buffer.append("')");
    }
}

