/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.ProtocolConfigurationSanitizer;
import org.apache.james.RunArguments;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.ConfigurationSanitizer;
import org.apache.james.lmtpserver.netty.LMTPServerFactory;
import org.apache.james.modules.protocols.LmtpGuiceProbe;
import org.apache.james.protocols.lib.netty.CertificateReloadable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.util.LoggingLevel;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.KeystoreCreator;

public class LMTPServerModule
extends AbstractModule {
    protected void configure() {
        this.bind(LMTPServerFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(LmtpGuiceProbe.class);
        Multibinder.newSetBinder((Binder)this.binder(), CertificateReloadable.Factory.class).addBinding().to(LMTPServerFactory.class);
    }

    @ProvidesIntoSet
    InitializationOperation configureLmtp(ConfigurationProvider configurationProvider, LMTPServerFactory lmtpServerFactory) {
        return InitilizationOperationBuilder.forClass(LMTPServerFactory.class).init(() -> {
            lmtpServerFactory.configure(configurationProvider.getConfiguration("lmtpserver", LoggingLevel.INFO));
            lmtpServerFactory.init();
        });
    }

    @ProvidesIntoSet
    ConfigurationSanitizer configurationSanitizer(ConfigurationProvider configurationProvider, KeystoreCreator keystoreCreator, FileSystem fileSystem, RunArguments runArguments) {
        return new ProtocolConfigurationSanitizer(configurationProvider, keystoreCreator, fileSystem, runArguments, "lmtpserver");
    }
}

