/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.msearch;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.msearch.MultiSearchResponseItem;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class MultiSearchResult<TDocument>
implements JsonpSerializable {
    private final long took;
    private final List<MultiSearchResponseItem<TDocument>> responses;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    protected MultiSearchResult(AbstractBuilder<TDocument, ?> builder) {
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
        this.responses = ApiTypeHelper.unmodifiableRequired(builder.responses, (Object)this, "responses");
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public final long took() {
        return this.took;
    }

    public final List<MultiSearchResponseItem<TDocument>> responses() {
        return this.responses;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        if (ApiTypeHelper.isDefined(this.responses)) {
            generator.writeKey("responses");
            generator.writeStartArray();
            for (MultiSearchResponseItem<TDocument> item0 : this.responses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupMultiSearchResultDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(AbstractBuilder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(AbstractBuilder::responses, JsonpDeserializer.arrayDeserializer(MultiSearchResponseItem.createMultiSearchResponseItemDeserializer(tDocumentDeserializer)), "responses");
    }

    protected static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>>
    extends ObjectBuilderBase {
        private Long took;
        private List<MultiSearchResponseItem<TDocument>> responses;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        protected AbstractBuilder() {
        }

        public final BuilderT took(long value) {
            this.took = value;
            return this.self();
        }

        public final BuilderT responses(List<MultiSearchResponseItem<TDocument>> list) {
            this.responses = AbstractBuilder._listAddAll(this.responses, list);
            return this.self();
        }

        public final BuilderT responses(MultiSearchResponseItem<TDocument> value, MultiSearchResponseItem<TDocument> ... values) {
            this.responses = AbstractBuilder._listAdd(this.responses, value, values);
            return this.self();
        }

        public final BuilderT responses(Function<MultiSearchResponseItem.Builder<TDocument>, ObjectBuilder<MultiSearchResponseItem<TDocument>>> fn) {
            return this.responses(fn.apply(new MultiSearchResponseItem.Builder()).build(), new MultiSearchResponseItem[0]);
        }

        public final BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

