/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Objects;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class HasAttachment
extends GenericMatcher {
    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Throwable anException;
        block9: {
            anException = null;
            try {
                MimeMessage message = mail.getMessage();
                if (message.getContentType() == null) {
                    return null;
                }
                Object content = message.getContent();
                if (content instanceof Multipart) {
                    Multipart multipart = (Multipart)content;
                    for (int i = 0; i < multipart.getCount(); ++i) {
                        try {
                            BodyPart part = multipart.getBodyPart(i);
                            if (!this.isAttachment((Part)part)) continue;
                            return mail.getRecipients();
                        }
                        catch (MessagingException e) {
                            anException = e;
                        }
                    }
                    break block9;
                }
                if (this.isAttachment((Part)message)) {
                    return mail.getRecipients();
                }
            }
            catch (Exception e) {
                anException = e;
            }
        }
        if (anException != null) {
            throw new MessagingException("Malformed message", (Exception)anException);
        }
        return null;
    }

    private boolean isAttachment(Part part) throws MessagingException {
        return Objects.equal((Object)part.getDisposition(), (Object)"attachment");
    }
}

