/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.mailbox.model.MessageId;

public class MessageIdDto {
    private final String messageId;

    public MessageIdDto(String messageId) {
        this.messageId = messageId;
    }

    public MessageIdDto(MessageId messageId) {
        this.messageId = messageId.serialize();
    }

    public MessageId instantiate(MessageId.Factory factory) {
        return factory.fromString(this.messageId);
    }

    public String asString() {
        return this.messageId;
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageIdDto) {
            MessageIdDto that = (MessageIdDto)o;
            return Objects.equals(this.messageId, that.messageId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.messageId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).toString();
    }
}

