/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.function.LongConsumer;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.Sorter;

public abstract class SortingNumericDocValues
extends SortedNumericDocValues {
    private int count;
    protected long[] values = new long[1];
    protected int valuesCursor = 0;
    private final Sorter sorter = new InPlaceMergeSorter(){

        protected void swap(int i, int j) {
            long tmp = SortingNumericDocValues.this.values[i];
            SortingNumericDocValues.this.values[i] = SortingNumericDocValues.this.values[j];
            SortingNumericDocValues.this.values[j] = tmp;
        }

        protected int compare(int i, int j) {
            return Long.compare(SortingNumericDocValues.this.values[i], SortingNumericDocValues.this.values[j]);
        }
    };
    private LongConsumer circuitBreakerConsumer;

    protected SortingNumericDocValues() {
        this(l -> {});
    }

    protected SortingNumericDocValues(LongConsumer circuitBreakerConsumer) {
        this.circuitBreakerConsumer = circuitBreakerConsumer;
        this.circuitBreakerConsumer.accept(8L);
    }

    protected final void resize(int newSize) {
        this.count = newSize;
        this.valuesCursor = 0;
        if (newSize <= this.values.length) {
            return;
        }
        long oldValuesSizeInBytes = this.values.length * 8;
        int newValuesLength = ArrayUtil.oversize((int)newSize, (int)8);
        this.circuitBreakerConsumer.accept(newValuesLength * 8);
        this.values = ArrayUtil.growExact((long[])this.values, (int)newValuesLength);
        this.circuitBreakerConsumer.accept(-oldValuesSizeInBytes);
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
    }

    public final int docValueCount() {
        return this.count;
    }

    public final long nextValue() {
        return this.values[this.valuesCursor++];
    }
}

