/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.github.fge.lambdas.Throwing;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.acl.PositiveUserACLDiff;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraUserMailboxRightsDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectUser;

    @Inject
    public CassandraUserMailboxRightsDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.delete = this.prepareDelete(session);
        this.insert = this.prepareInsert(session);
        this.select = this.prepareSelect(session);
        this.selectUser = this.prepareSelectAllForUser(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("UserMailboxACL").where(QueryBuilder.eq((String)"userName", (Object)QueryBuilder.bindMarker((String)"userName"))).and(QueryBuilder.eq((String)"mailboxid", (Object)QueryBuilder.bindMarker((String)"mailboxid"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"UserMailboxACL").value("userName", (Object)QueryBuilder.bindMarker((String)"userName")).value("mailboxid", (Object)QueryBuilder.bindMarker((String)"mailboxid")).value("rights", (Object)QueryBuilder.bindMarker((String)"rights")));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"rights"}).from("UserMailboxACL").where(QueryBuilder.eq((String)"userName", (Object)QueryBuilder.bindMarker((String)"userName"))).and(QueryBuilder.eq((String)"mailboxid", (Object)QueryBuilder.bindMarker((String)"mailboxid"))));
    }

    private PreparedStatement prepareSelectAllForUser(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"mailboxid", "rights"}).from("UserMailboxACL").where(QueryBuilder.eq((String)"userName", (Object)QueryBuilder.bindMarker((String)"userName"))));
    }

    public Mono<Void> update(CassandraId cassandraId, ACLDiff aclDiff) {
        PositiveUserACLDiff userACLDiff = new PositiveUserACLDiff(aclDiff);
        return Flux.merge((Publisher[])new Publisher[]{this.addAll(cassandraId, userACLDiff.addedEntries()), this.removeAll(cassandraId, userACLDiff.removedEntries()), this.addAll(cassandraId, userACLDiff.changedEntries())}).then();
    }

    private Flux<Void> removeAll(CassandraId cassandraId, Stream<MailboxACL.Entry> removedEntries) {
        return Flux.fromStream(removedEntries).flatMap(entry -> this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setString("userName", ((MailboxACL.EntryKey)entry.getKey()).getName()).setUUID("mailboxid", cassandraId.asUuid())), 16);
    }

    private Flux<Void> addAll(CassandraId cassandraId, Stream<MailboxACL.Entry> addedEntries) {
        return Flux.fromStream(addedEntries).flatMap(entry -> this.cassandraAsyncExecutor.executeVoid((Statement)this.insert.bind().setString("userName", ((MailboxACL.EntryKey)entry.getKey()).getName()).setUUID("mailboxid", cassandraId.asUuid()).setString("rights", ((MailboxACL.Rfc4314Rights)entry.getValue()).serialize())), 16);
    }

    public Mono<Optional<MailboxACL.Rfc4314Rights>> retrieve(Username userName, CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.select.bind().setString("userName", userName.asString()).setUUID("mailboxid", mailboxId.asUuid())).map(rowOptional -> rowOptional.map(Throwing.function(row -> MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)row.getString("rights")))));
    }

    public Flux<Pair<CassandraId, MailboxACL.Rfc4314Rights>> listRightsForUser(Username userName) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectUser.bind().setString("userName", userName.asString())).map((Function)Throwing.function(this::toPair));
    }

    private Pair<CassandraId, MailboxACL.Rfc4314Rights> toPair(Row row) throws UnsupportedRightException {
        return Pair.of((Object)CassandraId.of(row.getUUID("mailboxid")), (Object)MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)row.getString("rights")));
    }
}

