/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.service.SubscribeAllTask;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import spark.Request;

public class SubscribeAllRequestToTask
extends TaskFromRequestRegistry.TaskRegistration {
    public static final TaskRegistrationKey TASK_REGISTRATION_KEY = TaskRegistrationKey.of((String)"subscribeAll");

    @Inject
    SubscribeAllRequestToTask(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, UsersRepository usersRepository) {
        super(TASK_REGISTRATION_KEY, request -> SubscribeAllRequestToTask.toTask(mailboxManager, subscriptionManager, usersRepository, request));
    }

    private static Task toTask(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, UsersRepository usersRepository, Request request) throws UsersRepositoryException {
        Username username = Username.of((String)request.params("username"));
        if (usersRepository.contains(username)) {
            return new SubscribeAllTask(mailboxManager, subscriptionManager, username);
        }
        throw ErrorResponder.builder().type(ErrorResponder.ErrorType.NOT_FOUND).statusCode(404).message(String.format("User '%s' does not exist", username.asString())).haltError();
    }
}

