/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.james.mailbox.tika.TikaConfiguration;
import org.apache.james.mailbox.tika.TikaHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaHttpClientImpl
implements TikaHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TikaHttpClientImpl.class);
    private static final String RECURSIVE_METADATA_AS_TEXT_ENDPOINT = "/rmeta/text";
    private final TikaConfiguration tikaConfiguration;
    private final URI recursiveMetaData;

    public TikaHttpClientImpl(TikaConfiguration tikaConfiguration) throws URISyntaxException {
        this.tikaConfiguration = tikaConfiguration;
        this.recursiveMetaData = this.buildURI(tikaConfiguration).resolve(RECURSIVE_METADATA_AS_TEXT_ENDPOINT);
    }

    private URI buildURI(TikaConfiguration tikaConfiguration) throws URISyntaxException {
        return new URIBuilder().setHost(tikaConfiguration.getHost()).setPort(tikaConfiguration.getPort()).setScheme("http").build();
    }

    @Override
    public Optional<InputStream> recursiveMetaDataAsJson(InputStream inputStream, org.apache.james.mailbox.model.ContentType contentType) {
        try {
            ContentType httpContentType = ContentType.create((String)contentType.mimeType().asString(), (String)contentType.charset().map(Charset::name).orElse(null));
            return Optional.ofNullable(Request.Put((URI)this.recursiveMetaData).socketTimeout(this.tikaConfiguration.getTimeoutInMillis()).bodyStream(inputStream, httpContentType).execute().returnContent().asStream());
        }
        catch (IOException e) {
            LOGGER.warn("Failing to call Tika for content type {}", (Object)contentType, (Object)e);
            return Optional.empty();
        }
    }
}

