/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.mailbox.Mailbox;

public class GetMailboxesResponse
implements Method.Response {
    private final String accountId;
    private final String state;
    private final List<Mailbox> list;
    private final Optional<List<String>> notFound;

    public static Builder builder() {
        return new Builder();
    }

    private GetMailboxesResponse(String accountId, String state, List<Mailbox> list, Optional<List<String>> notFound) {
        this.accountId = accountId;
        this.state = state;
        this.list = list;
        this.notFound = notFound;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getState() {
        return this.state;
    }

    public List<Mailbox> getList() {
        return this.list;
    }

    public Optional<List<String>> getNotFound() {
        return this.notFound;
    }

    public static class Builder {
        private String accountId;
        private String state;
        private final ImmutableList.Builder<Mailbox> mailboxes = ImmutableList.builder();
        private final ImmutableList.Builder<String> notFoundBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder accountId(String accountId) {
            if (accountId != null) {
                throw new NotImplementedException("not implemented");
            }
            return this;
        }

        public Builder state(String state) {
            if (state != null) {
                throw new NotImplementedException("not implemented");
            }
            return this;
        }

        public Builder add(Mailbox mailbox) {
            this.mailboxes.add((Object)mailbox);
            return this;
        }

        public Builder addAll(List<Mailbox> list) {
            this.mailboxes.addAll(list);
            return this;
        }

        public Builder notFound(String[] notFound) {
            if (notFound != null) {
                throw new NotImplementedException("not implemented");
            }
            return this;
        }

        public GetMailboxesResponse build() {
            ImmutableList notFound = this.notFoundBuilder.build();
            return new GetMailboxesResponse(this.accountId, this.state, (List<Mailbox>)this.mailboxes.build(), notFound.isEmpty() ? Optional.empty() : Optional.of(notFound));
        }
    }
}

