/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.draft.model.Filter;
import org.apache.james.jmap.draft.model.Header;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.jmap.draft.model.Number;

@JsonDeserialize(builder=Builder.class)
public class FilterCondition
implements Filter {
    private final Optional<List<String>> inMailboxes;
    private final Optional<List<String>> notInMailboxes;
    private final Optional<ZonedDateTime> before;
    private final Optional<ZonedDateTime> after;
    private final Optional<Number> minSize;
    private final Optional<Number> maxSize;
    private final Optional<Boolean> isFlagged;
    private final Optional<Boolean> isUnread;
    private final Optional<Boolean> isAnswered;
    private final Optional<Boolean> isDraft;
    private final Optional<Boolean> isForwarded;
    private final Optional<Boolean> hasAttachment;
    private final Optional<String> text;
    private final Optional<String> from;
    private final Optional<String> to;
    private final Optional<String> cc;
    private final Optional<String> bcc;
    private final Optional<String> subject;
    private final Optional<String> body;
    private final Optional<String> attachments;
    private final Optional<Header> header;
    private final Optional<String> hasKeyword;
    private final Optional<String> notKeyword;
    private final Optional<String> attachmentFileName;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    FilterCondition(Optional<List<String>> inMailboxes, Optional<List<String>> notInMailboxes, Optional<ZonedDateTime> before, Optional<ZonedDateTime> after, Optional<Number> minSize, Optional<Number> maxSize, Optional<Boolean> isFlagged, Optional<Boolean> isUnread, Optional<Boolean> isAnswered, Optional<Boolean> isDraft, Optional<Boolean> isForwarded, Optional<Boolean> hasAttachment, Optional<String> text, Optional<String> from, Optional<String> to, Optional<String> cc, Optional<String> bcc, Optional<String> subject, Optional<String> body, Optional<String> attachments, Optional<Header> header, Optional<String> hasKeyword, Optional<String> notKeyword, Optional<String> attachmentFileName) {
        this.inMailboxes = inMailboxes;
        this.notInMailboxes = notInMailboxes;
        this.before = before;
        this.after = after;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.isFlagged = isFlagged;
        this.isUnread = isUnread;
        this.isAnswered = isAnswered;
        this.isDraft = isDraft;
        this.isForwarded = isForwarded;
        this.hasAttachment = hasAttachment;
        this.text = text;
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.body = body;
        this.attachments = attachments;
        this.header = header;
        this.hasKeyword = hasKeyword;
        this.notKeyword = notKeyword;
        this.attachmentFileName = attachmentFileName;
    }

    @Override
    public boolean inMailboxFilterOnly() {
        return this.inMailboxes.filter(list -> list.size() == 1).isPresent() && this.after.isEmpty() && this.noOtherFiltersSet();
    }

    @Override
    public boolean inMailboxAndAfterFiltersOnly() {
        return this.inMailboxes.filter(list -> list.size() == 1).isPresent() && this.after.isPresent() && this.noOtherFiltersSet();
    }

    private boolean noOtherFiltersSet() {
        return this.notInMailboxes.isEmpty() && this.before.isEmpty() && this.minSize.isEmpty() && this.maxSize.isEmpty() && this.isFlagged.isEmpty() && this.isUnread.isEmpty() && this.isAnswered.isEmpty() && this.isDraft.isEmpty() && this.isForwarded.isEmpty() && this.hasAttachment.isEmpty() && this.text.isEmpty() && this.from.isEmpty() && this.to.isEmpty() && this.cc.isEmpty() && this.bcc.isEmpty() && this.subject.isEmpty() && this.body.isEmpty() && this.attachments.isEmpty() && this.header.isEmpty() && this.hasKeyword.isEmpty() && this.notKeyword.isEmpty() && this.attachmentFileName.isEmpty();
    }

    public Optional<List<String>> getInMailboxes() {
        return this.inMailboxes;
    }

    public Optional<List<String>> getNotInMailboxes() {
        return this.notInMailboxes;
    }

    public Optional<ZonedDateTime> getBefore() {
        return this.before;
    }

    public Optional<ZonedDateTime> getAfter() {
        return this.after;
    }

    public Optional<Number> getMinSize() {
        return this.minSize;
    }

    public Optional<Number> getMaxSize() {
        return this.maxSize;
    }

    public Optional<Boolean> getIsFlagged() {
        return this.isFlagged;
    }

    public Optional<Boolean> getIsUnread() {
        return this.isUnread;
    }

    public Optional<Boolean> getIsAnswered() {
        return this.isAnswered;
    }

    public Optional<Boolean> getIsDraft() {
        return this.isDraft;
    }

    public Optional<Boolean> getIsForwarded() {
        return this.isForwarded;
    }

    public Optional<Boolean> getHasAttachment() {
        return this.hasAttachment;
    }

    public Optional<String> getText() {
        return this.text;
    }

    public Optional<String> getFrom() {
        return this.from;
    }

    public Optional<String> getTo() {
        return this.to;
    }

    public Optional<String> getCc() {
        return this.cc;
    }

    public Optional<String> getBcc() {
        return this.bcc;
    }

    public Optional<String> getSubject() {
        return this.subject;
    }

    public Optional<String> getBody() {
        return this.body;
    }

    public Optional<String> getAttachments() {
        return this.attachments;
    }

    public Optional<Header> getHeader() {
        return this.header;
    }

    public Optional<String> getHasKeyword() {
        return this.hasKeyword;
    }

    public Optional<String> getNotKeyword() {
        return this.notKeyword;
    }

    public Optional<String> getAttachmentFileName() {
        return this.attachmentFileName;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof FilterCondition) {
            FilterCondition other = (FilterCondition)obj;
            return Objects.equals(this.inMailboxes, other.inMailboxes) && Objects.equals(this.notInMailboxes, other.notInMailboxes) && Objects.equals(this.before, other.before) && Objects.equals(this.after, other.after) && Objects.equals(this.minSize, other.minSize) && Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.isFlagged, other.isFlagged) && Objects.equals(this.isUnread, other.isUnread) && Objects.equals(this.isAnswered, other.isAnswered) && Objects.equals(this.isDraft, other.isDraft) && Objects.equals(this.isForwarded, other.isForwarded) && Objects.equals(this.hasAttachment, other.hasAttachment) && Objects.equals(this.text, other.text) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.cc, other.cc) && Objects.equals(this.bcc, other.bcc) && Objects.equals(this.subject, other.subject) && Objects.equals(this.body, other.body) && Objects.equals(this.attachments, other.attachments) && Objects.equals(this.header, other.header) && Objects.equals(this.hasKeyword, other.hasKeyword) && Objects.equals(this.notKeyword, other.notKeyword) && Objects.equals(this.attachmentFileName, other.attachmentFileName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.inMailboxes, this.notInMailboxes, this.before, this.after, this.minSize, this.maxSize, this.isFlagged, this.isUnread, this.isAnswered, this.isDraft, this.isForwarded, this.hasAttachment, this.text, this.from, this.to, this.cc, this.bcc, this.subject, this.body, this.attachments, this.header, this.hasKeyword, this.notKeyword, this.attachmentFileName);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.getClass());
        this.inMailboxes.ifPresent(x -> helper.add("inMailboxes", x));
        this.notInMailboxes.ifPresent(x -> helper.add("notInMailboxes", x));
        this.before.ifPresent(x -> helper.add("before", x));
        this.after.ifPresent(x -> helper.add("after", x));
        this.minSize.ifPresent(x -> helper.add("minSize", x));
        this.maxSize.ifPresent(x -> helper.add("maxSize", x));
        this.isFlagged.ifPresent(x -> helper.add("isFlagged", x));
        this.isUnread.ifPresent(x -> helper.add("isUnread", x));
        this.isAnswered.ifPresent(x -> helper.add("isAnswered", x));
        this.isDraft.ifPresent(x -> helper.add("isDraft", x));
        this.isForwarded.ifPresent(x -> helper.add("isForwarded", x));
        this.hasAttachment.ifPresent(x -> helper.add("hasAttachment", x));
        this.text.ifPresent(x -> helper.add("text", x));
        this.from.ifPresent(x -> helper.add("from", x));
        this.to.ifPresent(x -> helper.add("to", x));
        this.cc.ifPresent(x -> helper.add("cc", x));
        this.bcc.ifPresent(x -> helper.add("bcc", x));
        this.subject.ifPresent(x -> helper.add("subject", x));
        this.body.ifPresent(x -> helper.add("body", x));
        this.attachments.ifPresent(x -> helper.add("attachments", x));
        this.header.ifPresent(x -> helper.add("header", x));
        this.hasKeyword.ifPresent(x -> helper.add("hasKeyword", x));
        this.notKeyword.ifPresent(x -> helper.add("notKeyword", x));
        this.attachmentFileName.ifPresent(x -> helper.add("attachmentFileName", x));
        return helper.toString();
    }

    @Override
    public String prettyPrint(String indentation) {
        return indentation + this.toString() + "\n";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Optional<List<String>> inMailboxes = Optional.empty();
        private Optional<List<String>> notInMailboxes = Optional.empty();
        private ZonedDateTime before;
        private ZonedDateTime after;
        private Number minSize;
        private Number maxSize;
        private Boolean isFlagged;
        private Boolean isUnread;
        private Boolean isAnswered;
        private Boolean isForwarded;
        private Boolean isDraft;
        private Boolean hasAttachment;
        private String text;
        private String from;
        private String to;
        private String cc;
        private String bcc;
        private String subject;
        private String body;
        private String attachments;
        private Header header;
        private Optional<String> hasKeyword = Optional.empty();
        private Optional<String> notKeyword = Optional.empty();
        private Optional<String> attachmentFileName = Optional.empty();

        private Builder() {
        }

        public Builder inMailboxes(String ... inMailboxes) {
            this.inMailboxes = Optional.of(ImmutableList.copyOf((Object[])inMailboxes));
            return this;
        }

        @JsonDeserialize
        public Builder inMailboxes(Optional<List<String>> inMailboxes) {
            this.inMailboxes = inMailboxes.map(ImmutableList::copyOf);
            return this;
        }

        public Builder notInMailboxes(String ... notInMailboxes) {
            this.notInMailboxes = Optional.of(ImmutableList.copyOf((Object[])notInMailboxes));
            return this;
        }

        @JsonDeserialize
        public Builder notInMailboxes(Optional<List<String>> notInMailboxes) {
            this.notInMailboxes = notInMailboxes.map(ImmutableList::copyOf);
            return this;
        }

        @JsonDeserialize
        public Builder hasKeyword(Optional<String> hasKeyword) {
            this.hasKeyword = hasKeyword;
            return this;
        }

        @JsonDeserialize
        public Builder notKeyword(Optional<String> notKeyword) {
            this.notKeyword = notKeyword;
            return this;
        }

        public Builder before(ZonedDateTime before) {
            this.before = before;
            return this;
        }

        public Builder after(ZonedDateTime after) {
            this.after = after;
            return this;
        }

        public Builder minSize(long minSize) {
            this.minSize = Number.DEFAULT_FACTORY.from(minSize).orElseThrow(() -> new IllegalArgumentException("value should be positive and less than 2^53"));
            return this;
        }

        public Builder maxSize(long maxSize) {
            this.maxSize = Number.DEFAULT_FACTORY.from(maxSize).orElseThrow(() -> new IllegalArgumentException("value should be positive and less than 2^53"));
            return this;
        }

        public Builder isFlagged(boolean isFlagged) {
            this.isFlagged = isFlagged;
            return this;
        }

        public Builder isUnread(boolean isUnread) {
            this.isUnread = isUnread;
            return this;
        }

        public Builder isAnswered(boolean isAnswered) {
            this.isAnswered = isAnswered;
            return this;
        }

        public Builder isDraft(boolean isDraft) {
            this.isDraft = isDraft;
            return this;
        }

        public Builder isForwarded(boolean isForwarded) {
            this.isForwarded = isForwarded;
            return this;
        }

        public Builder hasAttachment(boolean hasAttachment) {
            this.hasAttachment = hasAttachment;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder cc(String cc) {
            this.cc = cc;
            return this;
        }

        public Builder bcc(String bcc) {
            this.bcc = bcc;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder attachments(String attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder header(Header header) {
            this.header = header;
            return this;
        }

        public Builder attachmentFileName(Optional<String> attachmentFileName) {
            this.attachmentFileName = attachmentFileName;
            return this;
        }

        public FilterCondition build() {
            Preconditions.checkArgument((!this.hasKeyword.isPresent() || Keyword.of(this.hasKeyword.get()) != null ? 1 : 0) != 0, (Object)"hasKeyword is not valid");
            Preconditions.checkArgument((!this.notKeyword.isPresent() || Keyword.of(this.notKeyword.get()) != null ? 1 : 0) != 0, (Object)"notKeyword is not valid");
            return new FilterCondition(this.inMailboxes, this.notInMailboxes, Optional.ofNullable(this.before), Optional.ofNullable(this.after), Optional.ofNullable(this.minSize), Optional.ofNullable(this.maxSize), Optional.ofNullable(this.isFlagged), Optional.ofNullable(this.isUnread), Optional.ofNullable(this.isAnswered), Optional.ofNullable(this.isDraft), Optional.ofNullable(this.isForwarded), Optional.ofNullable(this.hasAttachment), Optional.ofNullable(this.text), Optional.ofNullable(this.from), Optional.ofNullable(this.to), Optional.ofNullable(this.cc), Optional.ofNullable(this.bcc), Optional.ofNullable(this.subject), Optional.ofNullable(this.body), Optional.ofNullable(this.attachments), Optional.ofNullable(this.header), this.hasKeyword, this.notKeyword, this.attachmentFileName);
        }
    }
}

