/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.adapter.mailbox.MailboxManagerResolver;
import org.apache.james.adapter.mailbox.MailboxManagerResolverException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.utils.MailboxManagerDefinition;

public class GuiceMailboxManagerResolver
implements MailboxManagerResolver {
    private final ImmutableMap<String, MailboxManager> managers;

    @Inject
    private GuiceMailboxManagerResolver(Set<MailboxManagerDefinition> managers) {
        this.managers = GuiceMailboxManagerResolver.indexManagersByName(managers);
    }

    private static ImmutableMap<String, MailboxManager> indexManagersByName(Set<MailboxManagerDefinition> managers) {
        return ImmutableMap.copyOf(managers.stream().collect(Collectors.toMap(MailboxManagerDefinition::getName, MailboxManagerDefinition::getManager)));
    }

    public Map<String, MailboxManager> getMailboxManagerBeans() {
        return this.managers;
    }

    public MailboxManager resolveMailboxManager(String mailboxManagerClassName) {
        return Optional.ofNullable((MailboxManager)this.managers.get((Object)mailboxManagerClassName)).orElseThrow(() -> new MailboxManagerResolverException("Unable to find a mailbox manager with name " + mailboxManagerClassName));
    }
}

