/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jtransforms.fft.DoubleFFT_1D;

public class UDTFLowPass
implements UDTF {
    private static final String WPASS_PARAM = "wpass";
    private double wpass;
    private final DoubleArrayList valueList = new DoubleArrayList();
    private final LongArrayList timeList = new LongArrayList();

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64).validateRequiredAttribute(WPASS_PARAM).validate(x -> (Double)x > 0.0 && (Double)x < 1.0, "Wpass should be within (0,1).", (Object)validator.getParameters().getDouble(WPASS_PARAM));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.wpass = parameters.getDouble(WPASS_PARAM);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double v = Util.getValueAsDouble(row);
        if (Double.isFinite(v)) {
            this.valueList.add(v);
            this.timeList.add(row.getTime());
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        int i;
        int n = this.valueList.size();
        DoubleFFT_1D fft = new DoubleFFT_1D(n);
        double[] a = new double[2 * n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[2 * i2] = this.valueList.get(i2);
            a[2 * i2 + 1] = 0.0;
        }
        fft.complexForward(a);
        int m4 = (int)Math.ceil(this.wpass * (double)n / 2.0);
        for (i = 2 * m4; i <= 2 * (n - m4) + 1; ++i) {
            a[i] = 0.0;
        }
        fft.complexInverse(a, true);
        for (i = 0; i < n; ++i) {
            collector.putDouble(this.timeList.get(i), a[i * 2]);
        }
    }
}

