/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.Utils;
import io.moquette.broker.subscriptions.ShareName;
import io.moquette.broker.subscriptions.SharedSubscription;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionIdentifier;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2SubscriptionsRepository
implements ISubscriptionsRepository {
    private static final Logger LOG = LoggerFactory.getLogger(H2SubscriptionsRepository.class);
    private static final String SUBSCRIPTIONS_MAP = "subscriptions";
    private static final String SHARED_SUBSCRIPTIONS_MAP = "shared_subscriptions";
    private final MVStore mvStore;
    private final MVMap.Builder<Utils.Couple<ShareName, Topic>, SubscriptionOptionAndId> submapBuilder;
    private MVMap<String, Subscription> subscriptions;
    private MVMap<String, String> sharedSubscriptions;
    private final MVMap.Builder<String, Subscription> subscriptionBuilder = new MVMap.Builder().valueType((DataType)new SubscriptionValueType());

    H2SubscriptionsRepository(MVStore mvStore) {
        this.mvStore = mvStore;
        this.submapBuilder = new MVMap.Builder().keyType((DataType)new CoupleValueType()).valueType((DataType)new SubscriptionOptionAndIdValueType());
        this.subscriptions = mvStore.openMap(SUBSCRIPTIONS_MAP, this.subscriptionBuilder);
        this.sharedSubscriptions = mvStore.openMap(SHARED_SUBSCRIPTIONS_MAP);
    }

    @Override
    public Set<Subscription> listAllSubscriptions() {
        LOG.debug("Retrieving existing subscriptions");
        HashSet<Subscription> results = new HashSet<Subscription>();
        Cursor mapCursor = this.subscriptions.cursor(null);
        while (mapCursor.hasNext()) {
            String subscriptionStr = (String)mapCursor.next();
            results.add((Subscription)mapCursor.getValue());
        }
        LOG.debug("Loaded {} subscriptions", (Object)results.size());
        return results;
    }

    @Override
    public void addNewSubscription(Subscription subscription) {
        this.subscriptions.put((Object)(subscription.getTopicFilter() + "-" + subscription.getClientId()), (Object)subscription);
    }

    @Override
    public void removeSubscription(String topicFilter, String clientID) {
        this.subscriptions.remove((Object)(topicFilter + "-" + clientID));
    }

    @Override
    public void removeAllSharedSubscriptions(String clientId) {
        String sharedSubsMapName = (String)this.sharedSubscriptions.get((Object)clientId);
        if (sharedSubsMapName == null) {
            LOG.debug("Removing all shared subscription of a non existing client: {}", (Object)clientId);
            return;
        }
        this.wipeAllSharedSubscripptions(clientId, sharedSubsMapName);
    }

    private void wipeAllSharedSubscripptions(String clientId, String sharedSubsMapName) {
        this.mvStore.removeMap(sharedSubsMapName);
        this.sharedSubscriptions.remove((Object)clientId);
    }

    @Override
    public void removeSharedSubscription(String clientId, ShareName share, Topic topicFilter) {
        Utils.Couple<ShareName, Topic> sharedSubKey;
        String sharedSubsMapName = (String)this.sharedSubscriptions.get((Object)clientId);
        if (sharedSubsMapName == null) {
            LOG.info("Removing a non existing shared subscription for client: {}", (Object)clientId);
            return;
        }
        MVMap subMap = this.mvStore.openMap(sharedSubsMapName, this.submapBuilder);
        if (subMap.remove(sharedSubKey = Utils.Couple.of(share, topicFilter)) == null) {
            LOG.info("Removing non existing shared subscription name: {} filter: {} for client: {}", new Object[]{share, topicFilter, clientId});
            return;
        }
        if (subMap.isEmpty()) {
            LOG.debug("Removing all references for share subscription clientId: {} share: {} filter: {}", new Object[]{clientId, share, topicFilter});
            this.wipeAllSharedSubscripptions(clientId, sharedSubsMapName);
        }
    }

    @Override
    public void addNewSharedSubscription(String clientId, ShareName share, Topic topicFilter, MqttSubscriptionOption option) {
        SubscriptionOptionAndId qosPart = new SubscriptionOptionAndId(option);
        this.storeNewSharedSubscription(clientId, share, topicFilter, qosPart);
    }

    private void storeNewSharedSubscription(String clientId, ShareName share, Topic topicFilter, SubscriptionOptionAndId value) {
        String sharedSubsMapName = (String)this.sharedSubscriptions.computeIfAbsent((Object)clientId, H2SubscriptionsRepository::computeShareSubscriptionSubMap);
        MVMap subMap = this.mvStore.openMap(sharedSubsMapName, this.submapBuilder);
        subMap.put(Utils.Couple.of(share, topicFilter), (Object)value);
    }

    @Override
    public void addNewSharedSubscription(String clientId, ShareName share, Topic topicFilter, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionIdentifier) {
        SubscriptionOptionAndId qosAndSubscriptionIdPart = new SubscriptionOptionAndId(option, subscriptionIdentifier.value());
        this.storeNewSharedSubscription(clientId, share, topicFilter, qosAndSubscriptionIdPart);
    }

    @Override
    public Collection<SharedSubscription> listAllSharedSubscription() {
        ArrayList<SharedSubscription> result = new ArrayList<SharedSubscription>();
        for (Map.Entry entry : this.sharedSubscriptions.entrySet()) {
            String clientId = (String)entry.getKey();
            String sharedSubsMapName = (String)entry.getValue();
            MVMap subMap = this.mvStore.openMap(sharedSubsMapName, this.submapBuilder);
            for (Map.Entry subEntry : subMap.entrySet()) {
                SharedSubscription subscription;
                ShareName shareName = (ShareName)((Utils.Couple)subEntry.getKey()).v1;
                Topic topicFilter = (Topic)((Utils.Couple)subEntry.getKey()).v2;
                MqttSubscriptionOption option = ((SubscriptionOptionAndId)subEntry.getValue()).option;
                if (((SubscriptionOptionAndId)subEntry.getValue()).subscriptionIdentifier == null) {
                    subscription = new SharedSubscription(shareName, topicFilter, clientId, option);
                } else {
                    SubscriptionIdentifier subscriptionId = new SubscriptionIdentifier(((SubscriptionOptionAndId)subEntry.getValue()).subscriptionIdentifier);
                    subscription = new SharedSubscription(shareName, topicFilter, clientId, option, subscriptionId);
                }
                result.add(subscription);
            }
        }
        return result;
    }

    private static String computeShareSubscriptionSubMap(String sessionId) {
        return "shared_subscriptions_" + sessionId;
    }

    private static final class SubscriptionValueType
    extends BasicDataType<Subscription> {
        private SubscriptionValueType() {
        }

        public int getMemory(Subscription sub) {
            return StringDataType.INSTANCE.getMemory(sub.getClientId()) + StringDataType.INSTANCE.getMemory(sub.getTopicFilter().toString()) + SubscriptionOptionValueType.INSTANCE.getMemory(sub.option()) + 1 + (sub.hasShareName() ? StringDataType.INSTANCE.getMemory(sub.getShareName()) : 0) + (sub.hasSubscriptionIdentifier() ? 4 : 0);
        }

        public void write(WriteBuffer buff, Subscription sub) {
            StringDataType.INSTANCE.write(buff, sub.getClientId());
            StringDataType.INSTANCE.write(buff, sub.getTopicFilter().toString());
            SubscriptionOptionValueType.INSTANCE.write(buff, sub.option());
            byte flag = (byte)((sub.hasShareName() ? 1 : 0) | (sub.hasSubscriptionIdentifier() ? 2 : 0));
            buff.put(flag);
            if (sub.hasShareName()) {
                StringDataType.INSTANCE.write(buff, sub.getShareName());
            }
            if (sub.hasSubscriptionIdentifier()) {
                buff.putInt(sub.getSubscriptionIdentifier().value());
            }
        }

        public Subscription read(ByteBuffer buff) {
            boolean hasSubscriptionIdentifier;
            String clientId = StringDataType.INSTANCE.read(buff);
            String topicFilter = StringDataType.INSTANCE.read(buff);
            MqttSubscriptionOption options = SubscriptionOptionValueType.INSTANCE.read(buff);
            byte flag = buff.get();
            boolean hasShareName = (flag & 1) > 0;
            boolean bl = hasSubscriptionIdentifier = (flag & 2) > 0;
            if (hasShareName) {
                String shareName = StringDataType.INSTANCE.read(buff);
                if (hasSubscriptionIdentifier) {
                    SubscriptionIdentifier subId = new SubscriptionIdentifier(buff.getInt());
                    return new Subscription(clientId, Topic.asTopic(topicFilter), options, shareName, subId);
                }
                return new Subscription(clientId, Topic.asTopic(topicFilter), options, shareName);
            }
            if (hasSubscriptionIdentifier) {
                SubscriptionIdentifier subId = new SubscriptionIdentifier(buff.getInt());
                return new Subscription(clientId, Topic.asTopic(topicFilter), options, subId);
            }
            return new Subscription(clientId, Topic.asTopic(topicFilter), options);
        }

        public Subscription[] createStorage(int size) {
            return new Subscription[size];
        }
    }

    private static final class SubscriptionOptionValueType
    extends BasicDataType<MqttSubscriptionOption> {
        public static final SubscriptionOptionValueType INSTANCE = new SubscriptionOptionValueType();

        private SubscriptionOptionValueType() {
        }

        public int getMemory(MqttSubscriptionOption obj) {
            return 1;
        }

        public void write(WriteBuffer buff, MqttSubscriptionOption opt) {
            byte composed = (byte)(opt.qos().value() & 3);
            composed = (byte)(composed | (byte)(opt.isNoLocal() ? 1 : 0) << 2);
            composed = (byte)(composed | (byte)(opt.isRetainAsPublished() ? 1 : 0) << 3);
            composed = (byte)(composed | (byte)(opt.retainHandling().value() << 4));
            buff.put(composed);
        }

        public MqttSubscriptionOption read(ByteBuffer buff) {
            byte fields = buff.get();
            MqttQoS qos = MqttQoS.valueOf((int)(fields & 3));
            boolean noLocal = (fields & 4) > 0;
            boolean retainAsPublished = (fields & 8) > 0;
            MqttSubscriptionOption.RetainedHandlingPolicy retainedHandlingPolicy = MqttSubscriptionOption.RetainedHandlingPolicy.valueOf((int)((fields & 0x30) >> 4));
            return new MqttSubscriptionOption(qos, noLocal, retainAsPublished, retainedHandlingPolicy);
        }

        public MqttSubscriptionOption[] createStorage(int size) {
            return new MqttSubscriptionOption[size];
        }
    }

    private static final class SubscriptionOptionAndIdValueType
    extends BasicDataType<SubscriptionOptionAndId> {
        private SubscriptionOptionAndIdValueType() {
        }

        public int getMemory(SubscriptionOptionAndId obj) {
            return 4 + SubscriptionOptionValueType.INSTANCE.getMemory(obj.option);
        }

        public void write(WriteBuffer buff, SubscriptionOptionAndId obj) {
            if (obj.subscriptionIdentifier != null) {
                buff.putInt(obj.subscriptionIdentifier.intValue());
            } else {
                buff.putInt(-1);
            }
            SubscriptionOptionValueType.INSTANCE.write(buff, obj.option);
        }

        public SubscriptionOptionAndId read(ByteBuffer buff) {
            int subId = buff.getInt();
            MqttSubscriptionOption option = SubscriptionOptionValueType.INSTANCE.read(buff);
            if (subId != -1) {
                return new SubscriptionOptionAndId(option, subId);
            }
            return new SubscriptionOptionAndId(option);
        }

        public SubscriptionOptionAndId[] createStorage(int size) {
            return new SubscriptionOptionAndId[size];
        }
    }

    static final class CoupleValueType
    extends BasicDataType<Utils.Couple<ShareName, Topic>> {
        private final Comparator<Utils.Couple<ShareName, Topic>> coupleComparator = Comparator.comparing(c -> ((ShareName)c.v1).getShareName()).thenComparing(c -> ((Topic)c.v2).toString());

        CoupleValueType() {
        }

        public int compare(Utils.Couple<ShareName, Topic> var1, Utils.Couple<ShareName, Topic> var2) {
            return this.coupleComparator.compare(var1, var2);
        }

        public int getMemory(Utils.Couple<ShareName, Topic> couple) {
            return StringDataType.INSTANCE.getMemory(((ShareName)couple.v1).getShareName()) + StringDataType.INSTANCE.getMemory(((Topic)couple.v2).toString());
        }

        public void write(WriteBuffer buff, Utils.Couple<ShareName, Topic> couple) {
            StringDataType.INSTANCE.write(buff, ((ShareName)couple.v1).getShareName());
            StringDataType.INSTANCE.write(buff, ((Topic)couple.v2).toString());
        }

        public Utils.Couple<ShareName, Topic> read(ByteBuffer buffer) {
            String shareName = StringDataType.INSTANCE.read(buffer);
            String topicFilter = StringDataType.INSTANCE.read(buffer);
            return new Utils.Couple<ShareName, Topic>(new ShareName(shareName), Topic.asTopic(topicFilter));
        }

        public Utils.Couple<ShareName, Topic>[] createStorage(int i) {
            return new Utils.Couple[i];
        }
    }

    private static class SubscriptionOptionAndId
    implements Serializable {
        final MqttSubscriptionOption option;
        final Integer subscriptionIdentifier;

        public SubscriptionOptionAndId(MqttSubscriptionOption option, int subscriptionIdentifier) {
            this.option = option;
            this.subscriptionIdentifier = subscriptionIdentifier;
        }

        public SubscriptionOptionAndId(MqttSubscriptionOption option) {
            this.option = option;
            this.subscriptionIdentifier = null;
        }
    }
}

