/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;

public class TransactionContextImpl
implements TransactionContext {
    private final RaftProtos.RaftPeerRole serverRole;
    private final StateMachine stateMachine;
    private final RaftClientRequest clientRequest;
    private volatile Exception exception;
    private final RaftProtos.StateMachineLogEntryProto stateMachineLogEntry;
    private volatile Object stateMachineContext;
    private boolean shouldCommit = true;
    private volatile RaftProtos.LogEntryProto logEntry;
    private final CompletableFuture<Long> logIndexFuture = new CompletableFuture();

    private TransactionContextImpl(RaftProtos.RaftPeerRole serverRole, RaftClientRequest clientRequest, StateMachine stateMachine, RaftProtos.StateMachineLogEntryProto stateMachineLogEntry) {
        this.serverRole = serverRole;
        this.clientRequest = clientRequest;
        this.stateMachine = stateMachine;
        this.stateMachineLogEntry = stateMachineLogEntry;
    }

    TransactionContextImpl(RaftClientRequest clientRequest, StateMachine stateMachine, RaftProtos.StateMachineLogEntryProto stateMachineLogEntry, ByteString logData, ByteString stateMachineData, Object stateMachineContext) {
        this(RaftProtos.RaftPeerRole.LEADER, clientRequest, stateMachine, TransactionContextImpl.get(stateMachineLogEntry, clientRequest, logData, stateMachineData));
        this.stateMachineContext = stateMachineContext;
    }

    private static RaftProtos.StateMachineLogEntryProto get(RaftProtos.StateMachineLogEntryProto stateMachineLogEntry, RaftClientRequest clientRequest, ByteString logData, ByteString stateMachineData) {
        if (stateMachineLogEntry != null) {
            return stateMachineLogEntry;
        }
        return LogProtoUtils.toStateMachineLogEntryProto(clientRequest, logData, stateMachineData);
    }

    TransactionContextImpl(RaftProtos.RaftPeerRole serverRole, StateMachine stateMachine, RaftProtos.LogEntryProto logEntry) {
        this(serverRole, null, stateMachine, logEntry.getStateMachineLogEntry());
        this.logEntry = logEntry;
        this.logIndexFuture.complete(logEntry.getIndex());
    }

    public RaftProtos.RaftPeerRole getServerRole() {
        return this.serverRole;
    }

    public RaftClientRequest getClientRequest() {
        return this.clientRequest;
    }

    public RaftProtos.StateMachineLogEntryProto getStateMachineLogEntry() {
        return this.stateMachineLogEntry;
    }

    public Exception getException() {
        return this.exception;
    }

    public TransactionContext setStateMachineContext(Object context) {
        this.stateMachineContext = context;
        return this;
    }

    public Object getStateMachineContext() {
        return this.stateMachineContext;
    }

    public RaftProtos.LogEntryProto initLogEntry(long term, long index) {
        Preconditions.assertTrue((this.serverRole == RaftProtos.RaftPeerRole.LEADER ? 1 : 0) != 0);
        Preconditions.assertNull((Object)this.logEntry, (String)"logEntry");
        Objects.requireNonNull(this.stateMachineLogEntry, "stateMachineLogEntry == null");
        this.logIndexFuture.complete(index);
        this.logEntry = LogProtoUtils.toLogEntryProto(this.stateMachineLogEntry, term, index);
        return this.logEntry;
    }

    public CompletableFuture<Long> getLogIndexFuture() {
        return this.logIndexFuture;
    }

    public RaftProtos.LogEntryProto getLogEntry() {
        return this.logEntry;
    }

    public TransactionContext setException(Exception ioe) {
        this.exception = ioe;
        return this;
    }

    public TransactionContext setShouldCommit(boolean sCommit) {
        this.shouldCommit = sCommit;
        return this;
    }

    public boolean shouldCommit() {
        return this.shouldCommit;
    }

    public TransactionContext preAppendTransaction() throws IOException {
        return this.stateMachine.preAppendTransaction((TransactionContext)this);
    }

    public TransactionContext cancelTransaction() throws IOException {
        return this.stateMachine.cancelTransaction((TransactionContext)this);
    }
}

