/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.util.function.Function;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;

public class DeviceIDFactory {
    private Function<String, IDeviceID> getDeviceIDFunction = PlainDeviceID::new;

    public static DeviceIDFactory getInstance() {
        return DeviceIDFactoryHolder.INSTANCE;
    }

    private DeviceIDFactory() {
    }

    public IDeviceID getDeviceID(PartialPath devicePath) {
        return this.getDeviceIDFunction.apply(devicePath.getFullPath());
    }

    public IDeviceID getDeviceID(String devicePath) {
        return this.getDeviceIDFunction.apply(DataNodeDevicePathCache.getInstance().getDeviceId(devicePath));
    }

    public void reset() {
        this.getDeviceIDFunction = PlainDeviceID::new;
    }

    private static class DeviceIDFactoryHolder {
        private static final DeviceIDFactory INSTANCE = new DeviceIDFactory();

        private DeviceIDFactoryHolder() {
        }
    }
}

