/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Configuration;
import com.bugsnag.Stackframe;
import com.bugsnag.serialization.Expose;
import java.util.List;

class Exception {
    private Configuration config;
    private Throwable throwable;
    private String errorClass;

    Exception(Configuration config, Throwable throwable) {
        this.config = config;
        this.throwable = throwable;
        this.errorClass = throwable.getClass().getName();
    }

    @Expose
    public String getErrorClass() {
        return this.errorClass;
    }

    @Expose
    public String getMessage() {
        return this.throwable.getLocalizedMessage();
    }

    @Expose
    public List<Stackframe> getStacktrace() {
        return Stackframe.getStacktrace(this.config, this.throwable.getStackTrace());
    }

    public void setErrorClass(String errorClass) {
        this.errorClass = errorClass;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

