/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.query.udf.service.TemporaryQueryDataFileService;
import org.apache.iotdb.tsfile.utils.PublicBAOS;

public interface SerializableList {
    public static final int INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL = IoTDBDescriptor.getInstance().getConfig().getUdfInitialByteArrayLengthForMemoryControl();

    public void serialize(PublicBAOS var1) throws IOException;

    public void deserialize(ByteBuffer var1);

    public void release();

    public void init();

    public SerializationRecorder getSerializationRecorder();

    default public void serialize() throws IOException {
        SerializationRecorder recorder = this.getSerializationRecorder();
        if (recorder.isSerialized()) {
            return;
        }
        PublicBAOS outputStream = new PublicBAOS();
        this.serialize(outputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(outputStream.size());
        byteBuffer.put(outputStream.getBuf(), 0, outputStream.size());
        byteBuffer.flip();
        recorder.getFileChannel().write(byteBuffer);
        recorder.closeFile();
        this.release();
        recorder.markAsSerialized();
    }

    default public void deserialize() throws IOException {
        SerializationRecorder recorder = this.getSerializationRecorder();
        if (!recorder.isSerialized()) {
            return;
        }
        this.init();
        ByteBuffer byteBuffer = ByteBuffer.allocate(recorder.getSerializedByteLength());
        recorder.getFileChannel().read(byteBuffer);
        byteBuffer.flip();
        this.deserialize(byteBuffer);
        recorder.closeFile();
        recorder.markAsNotSerialized();
    }

    public static class SerializationRecorder {
        protected static final int NOT_SERIALIZED = -1;
        protected final long queryId;
        protected boolean isSerialized;
        protected int serializedByteLength;
        protected int serializedElementSize;
        protected String fileName;
        protected RandomAccessFile file;
        protected FileChannel fileChannel;

        public SerializationRecorder(long queryId) {
            this.queryId = queryId;
            this.isSerialized = false;
            this.serializedByteLength = -1;
            this.serializedElementSize = -1;
        }

        public void markAsSerialized() {
            this.isSerialized = true;
        }

        public void markAsNotSerialized() {
            this.isSerialized = false;
            this.serializedByteLength = -1;
            this.serializedElementSize = -1;
        }

        public boolean isSerialized() {
            return this.isSerialized;
        }

        public void setSerializedByteLength(int serializedByteLength) {
            this.serializedByteLength = serializedByteLength;
        }

        public int getSerializedByteLength() {
            return this.serializedByteLength;
        }

        public void setSerializedElementSize(int serializedElementSize) {
            this.serializedElementSize = serializedElementSize;
        }

        public int getSerializedElementSize() {
            return this.serializedElementSize;
        }

        public RandomAccessFile getFile() throws IOException {
            if (this.file == null) {
                if (this.fileName == null) {
                    this.fileName = TemporaryQueryDataFileService.getInstance().register(this);
                }
                this.file = new RandomAccessFile(SystemFileFactory.INSTANCE.getFile(this.fileName), "rw");
            }
            return this.file;
        }

        public void closeFile() throws IOException {
            if (this.file == null) {
                return;
            }
            this.closeFileChannel();
            this.file.close();
            this.file = null;
        }

        public FileChannel getFileChannel() throws IOException {
            if (this.fileChannel == null) {
                this.fileChannel = this.getFile().getChannel();
            }
            return this.fileChannel;
        }

        public void closeFileChannel() throws IOException {
            if (this.fileChannel == null) {
                return;
            }
            this.fileChannel.close();
            this.fileChannel = null;
        }

        public long getQueryId() {
            return this.queryId;
        }
    }
}

