/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.reporter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.librato.metrics.client.Tag;
import com.librato.metrics.reporter.Json;
import java.util.Collections;
import java.util.List;

public class Signal {
    public String name;
    public String source;
    public List<Tag> tags = Collections.emptyList();
    public boolean overrideTags;

    public static Signal decode(String data) {
        if (data == null || data.length() < 2 || data.charAt(0) != '{') {
            return new Signal(data);
        }
        return Json.decode(data, Signal.class);
    }

    public Signal(String name) {
        this.name = name;
    }

    public Signal(String name, String source) {
        this.name = name;
        this.source = source;
    }

    @JsonCreator
    public Signal(@JsonProperty(value="name") String name, @JsonProperty(value="source") String source, @JsonProperty(value="tags") List<Tag> tags, @JsonProperty(value="overrideTags") boolean overrideTags) {
        this.name = name;
        this.source = source;
        if (tags != null) {
            this.tags = tags;
        }
        this.overrideTags = overrideTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signal signal = (Signal)o;
        if (this.overrideTags != signal.overrideTags) {
            return false;
        }
        if (this.name != null ? !this.name.equals(signal.name) : signal.name != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(signal.source) : signal.source != null) {
            return false;
        }
        return this.tags != null ? this.tags.equals(signal.tags) : signal.tags == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.overrideTags ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Signal{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", source='").append(this.source).append('\'');
        sb.append(", tags=").append(this.tags);
        sb.append(", overrideTags=").append(this.overrideTags);
        sb.append('}');
        return sb.toString();
    }
}

