/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.tsfile.encoding.bitpacking.IntPacker;
import org.apache.iotdb.tsfile.encoding.encoder.RleEncoder;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class IntRleEncoder
extends RleEncoder<Integer> {
    private IntPacker packer;

    public IntRleEncoder() {
        this.bufferedValues = new Integer[8];
        this.preValue = Integer.valueOf(0);
        this.values = new ArrayList();
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        this.values.add(value);
    }

    @Override
    public void encode(boolean value, ByteArrayOutputStream out) {
        if (value) {
            this.encode(1, out);
        } else {
            this.encode(0, out);
        }
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        this.bitWidth = ReadWriteForEncodingUtils.getIntMaxBitWidth(this.values);
        this.packer = new IntPacker(this.bitWidth);
        for (Integer value : this.values) {
            this.encodeValue(value);
        }
        super.flush(out);
    }

    @Override
    protected void reset() {
        super.reset();
        this.preValue = Integer.valueOf(0);
    }

    @Override
    protected void writeRleRun() throws IOException {
        this.endPreviousBitPackedRun(8);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(this.repeatCount << 1, this.byteCache);
        ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth((Integer)this.preValue, this.byteCache, this.bitWidth);
        this.repeatCount = 0;
        this.numBufferedValues = 0;
    }

    @Override
    protected void clearBuffer() {
        for (int i = this.numBufferedValues; i < 8; ++i) {
            ((Integer[])this.bufferedValues)[i] = 0;
        }
    }

    @Override
    protected void convertBuffer() {
        byte[] bytes = new byte[this.bitWidth];
        int[] tmpBuffer = new int[8];
        for (int i = 0; i < 8; ++i) {
            tmpBuffer[i] = ((Integer[])this.bufferedValues)[i];
        }
        this.packer.pack8Values(tmpBuffer, 0, bytes);
        this.bytesBuffer.add(bytes);
    }

    @Override
    public int getOneItemMaxSize() {
        return 45;
    }

    @Override
    public long getMaxByteSize() {
        if (this.values == null) {
            return 0L;
        }
        int groupNum = (this.values.size() / 8 + 1) / 63 + 1;
        return 8L + (long)(groupNum * 5) + (long)(this.values.size() * 4);
    }
}

