/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket;

import java.util.Arrays;
import java.util.List;
import zmq.Ctx;
import zmq.Options;
import zmq.SocketBase;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.net.Address;
import zmq.socket.Pair;
import zmq.socket.Stream;
import zmq.socket.pipeline.Pull;
import zmq.socket.pipeline.Push;
import zmq.socket.pubsub.Pub;
import zmq.socket.pubsub.Sub;
import zmq.socket.pubsub.XPub;
import zmq.socket.pubsub.XSub;
import zmq.socket.reqrep.Dealer;
import zmq.socket.reqrep.Rep;
import zmq.socket.reqrep.Req;
import zmq.socket.reqrep.Router;

public enum Sockets {
    PAIR(new String[]{"PAIR"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Pair(parent2, tid, sid);
        }
    }
    ,
    PUB(new String[]{"SUB", "XSUB"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Pub(parent2, tid, sid);
        }
    }
    ,
    SUB(new String[]{"PUB", "XPUB"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Sub(parent2, tid, sid);
        }
    }
    ,
    REQ(new String[]{"REP", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Req(parent2, tid, sid);
        }

        @Override
        public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options2, Address addr) {
            return new Req.ReqSession(ioThread, connect, socket, options2, addr);
        }
    }
    ,
    REP(new String[]{"REQ", "DEALER"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Rep(parent2, tid, sid);
        }
    }
    ,
    DEALER(new String[]{"REP", "DEALER", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Dealer(parent2, tid, sid);
        }
    }
    ,
    ROUTER(new String[]{"REQ", "DEALER", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Router(parent2, tid, sid);
        }
    }
    ,
    PULL(new String[]{"PUSH"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Pull(parent2, tid, sid);
        }
    }
    ,
    PUSH(new String[]{"PULL"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Push(parent2, tid, sid);
        }
    }
    ,
    XPUB(new String[]{"SUB", "XSUB"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new XPub(parent2, tid, sid);
        }
    }
    ,
    XSUB(new String[]{"PUB", "XPUB"}){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new XSub(parent2, tid, sid);
        }
    }
    ,
    STREAM(new String[0]){

        @Override
        SocketBase create(Ctx parent2, int tid, int sid) {
            return new Stream(parent2, tid, sid);
        }
    };

    private final List<String> compatible;

    private Sockets(String ... compatible) {
        this.compatible = Arrays.asList(compatible);
    }

    abstract SocketBase create(Ctx var1, int var2, int var3);

    public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options2, Address addr) {
        return new SessionBase(ioThread, connect, socket, options2, addr);
    }

    public static SessionBase createSession(IOThread ioThread, boolean connect, SocketBase socket, Options options2, Address addr) {
        return Sockets.values()[options2.type].create(ioThread, connect, socket, options2, addr);
    }

    public static SocketBase create(int socketType, Ctx parent2, int tid, int sid) {
        return Sockets.values()[socketType].create(parent2, tid, sid);
    }

    public static String name(int socketType) {
        return Sockets.values()[socketType].name();
    }

    public static Sockets fromType(int socketType) {
        return Sockets.values()[socketType];
    }

    public static boolean compatible(int self, String peer) {
        return Sockets.values()[self].compatible.contains(peer);
    }
}

