/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.joda.convert.FromString;
import org.joda.convert.FromStringFactory;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.ToString;

final class AnnotationStringConverterFactory
implements StringConverterFactory {
    static final StringConverterFactory INSTANCE = new AnnotationStringConverterFactory();

    private AnnotationStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        return this.findAnnotatedConverter(cls);
    }

    private <T> StringConverter<T> findAnnotatedConverter(Class<T> cls) {
        Method toString2 = this.findToStringMethod(cls);
        if (toString2 == null) {
            return null;
        }
        Constructor<T> con = this.findFromStringConstructor(cls);
        Method fromString2 = this.findFromStringMethod(cls, con == null);
        if (con == null && fromString2 == null) {
            throw new IllegalStateException("Class annotated with @ToString but not with @FromString: " + cls.getName());
        }
        if (con != null && fromString2 != null) {
            throw new IllegalStateException("Both method and constructor are annotated with @FromString: " + cls.getName());
        }
        if (con != null) {
            return new MethodConstructorStringConverter<T>(cls, toString2, con);
        }
        return new MethodsStringConverter<T>(cls, toString2, fromString2);
    }

    private Method findToStringMethod(Class<?> cls) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = loopCls.getDeclaredMethods()) {
                ToString toString2 = method.getAnnotation(ToString.class);
                if (toString2 == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString: " + cls.getName());
                }
                matched = method;
            }
        }
        if (matched == null) {
            for (Class<?> loopIfc : cls.getInterfaces()) {
                Method[] methods;
                for (Method method : methods = loopIfc.getDeclaredMethods()) {
                    ToString toString3 = method.getAnnotation(ToString.class);
                    if (toString3 == null) continue;
                    if (matched != null) {
                        throw new IllegalStateException("Two methods are annotated with @ToString on interfaces: " + cls.getName());
                    }
                    matched = method;
                }
            }
        }
        return matched;
    }

    private <T> Constructor<T> findFromStringConstructor(Class<T> cls) {
        Constructor<FromString> con;
        try {
            con = cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                con = cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
        FromString fromString2 = con.getAnnotation(FromString.class);
        return fromString2 != null ? con : null;
    }

    private Method findFromStringMethod(Class<?> cls, boolean searchSuperclasses) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            matched = this.findFromString(loopCls, matched);
            if (!searchSuperclasses) break;
        }
        if (searchSuperclasses && matched == null) {
            for (Class<?> loopIfc : cls.getInterfaces()) {
                matched = this.findFromString(loopIfc, matched);
            }
        }
        return matched;
    }

    private Method findFromString(Class<?> cls, Method matched) {
        Method[] methods;
        for (Method method : methods = cls.getDeclaredMethods()) {
            FromString fromString2 = method.getAnnotation(FromString.class);
            if (fromString2 == null) continue;
            if (matched != null) {
                throw new IllegalStateException("Two methods are annotated with @FromString: " + cls.getName());
            }
            matched = method;
        }
        FromStringFactory factory = cls.getAnnotation(FromStringFactory.class);
        if (factory != null) {
            Method[] factoryMethods;
            if (matched != null) {
                throw new IllegalStateException("Class annotated with @FromString and @FromStringFactory: " + cls.getName());
            }
            for (Method method : factoryMethods = factory.factory().getDeclaredMethods()) {
                FromString fromString3;
                if (!cls.isAssignableFrom(method.getReturnType()) || (fromString3 = method.getAnnotation(FromString.class)) == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @FromString on the factory: " + factory.factory().getName());
                }
                matched = method;
            }
        }
        return matched;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

